/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.shaded.redis.clients.jedis;

import com.amadeus.session.shaded.org.apache.commons.pool2.PooledObject;
import com.amadeus.session.shaded.org.apache.commons.pool2.PooledObjectFactory;
import com.amadeus.session.shaded.org.apache.commons.pool2.impl.DefaultPooledObject;
import com.amadeus.session.shaded.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import com.amadeus.session.shaded.redis.clients.jedis.Jedis;
import com.amadeus.session.shaded.redis.clients.jedis.JedisShardInfo;
import com.amadeus.session.shaded.redis.clients.jedis.ShardedJedis;
import com.amadeus.session.shaded.redis.clients.util.Hashing;
import com.amadeus.session.shaded.redis.clients.util.Pool;
import java.util.List;
import java.util.regex.Pattern;

public class ShardedJedisPool
extends Pool<ShardedJedis> {
    public ShardedJedisPool(GenericObjectPoolConfig poolConfig, List<JedisShardInfo> shards) {
        this(poolConfig, shards, Hashing.MURMUR_HASH);
    }

    public ShardedJedisPool(GenericObjectPoolConfig poolConfig, List<JedisShardInfo> shards, Hashing algo) {
        this(poolConfig, shards, algo, null);
    }

    public ShardedJedisPool(GenericObjectPoolConfig poolConfig, List<JedisShardInfo> shards, Pattern keyTagPattern) {
        this(poolConfig, shards, Hashing.MURMUR_HASH, keyTagPattern);
    }

    public ShardedJedisPool(GenericObjectPoolConfig poolConfig, List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        super(poolConfig, new ShardedJedisFactory(shards, algo, keyTagPattern));
    }

    @Override
    public ShardedJedis getResource() {
        ShardedJedis jedis = (ShardedJedis)super.getResource();
        jedis.setDataSource(this);
        return jedis;
    }

    @Override
    @Deprecated
    public void returnBrokenResource(ShardedJedis resource) {
        if (resource != null) {
            this.returnBrokenResourceObject(resource);
        }
    }

    @Override
    @Deprecated
    public void returnResource(ShardedJedis resource) {
        if (resource != null) {
            resource.resetState();
            this.returnResourceObject(resource);
        }
    }

    private static class ShardedJedisFactory
    implements PooledObjectFactory<ShardedJedis> {
        private List<JedisShardInfo> shards;
        private Hashing algo;
        private Pattern keyTagPattern;

        public ShardedJedisFactory(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
            this.shards = shards;
            this.algo = algo;
            this.keyTagPattern = keyTagPattern;
        }

        @Override
        public PooledObject<ShardedJedis> makeObject() throws Exception {
            ShardedJedis jedis = new ShardedJedis(this.shards, this.algo, this.keyTagPattern);
            return new DefaultPooledObject<ShardedJedis>(jedis);
        }

        @Override
        public void destroyObject(PooledObject<ShardedJedis> pooledShardedJedis) throws Exception {
            ShardedJedis shardedJedis = pooledShardedJedis.getObject();
            for (Jedis jedis : shardedJedis.getAllShards()) {
                try {
                    try {
                        jedis.quit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jedis.disconnect();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public boolean validateObject(PooledObject<ShardedJedis> pooledShardedJedis) {
            try {
                ShardedJedis jedis = pooledShardedJedis.getObject();
                for (Jedis shard : jedis.getAllShards()) {
                    if (shard.ping().equals("PONG")) continue;
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        @Override
        public void activateObject(PooledObject<ShardedJedis> p) throws Exception {
        }

        @Override
        public void passivateObject(PooledObject<ShardedJedis> p) throws Exception {
        }
    }
}

