/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.cache.normalized;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.cache.normalized.RecordSet;
import com.apollographql.apollo.internal.response.ResponseReaderShadow;
import com.apollographql.apollo.internal.util.SimpleStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ResponseNormalizer<R>
implements ResponseReaderShadow<R> {
    private SimpleStack<List<String>> pathStack;
    private SimpleStack<Record> recordStack;
    private SimpleStack<Object> valueStack;
    private List<String> path;
    private Record.Builder currentRecordBuilder;
    private RecordSet recordSet = new RecordSet();
    private Set<String> dependentKeys = Collections.emptySet();
    public static final ResponseNormalizer NO_OP_NORMALIZER = new ResponseNormalizer(){

        @Override
        public void willResolveRootQuery(Operation operation) {
        }

        @Override
        public void willResolve(ResponseField field, Operation.Variables variables) {
        }

        @Override
        public void didResolve(ResponseField field, Operation.Variables variables) {
        }

        @Override
        public void didResolveScalar(Object value) {
        }

        @Override
        public void willResolveObject(ResponseField field, Optional objectSource) {
        }

        @Override
        public void didResolveObject(ResponseField field, Optional objectSource) {
        }

        @Override
        public void didResolveList(List array) {
        }

        @Override
        public void willResolveElement(int atIndex) {
        }

        @Override
        public void didResolveElement(int atIndex) {
        }

        @Override
        public void didResolveNull() {
        }

        @Override
        public Collection<Record> records() {
            return Collections.emptyList();
        }

        @Override
        public Set<String> dependentKeys() {
            return Collections.emptySet();
        }

        @Nonnull
        public CacheKey resolveCacheKey(@Nonnull ResponseField field, @Nonnull Object record) {
            return CacheKey.NO_KEY;
        }
    };

    public Collection<Record> records() {
        return this.recordSet.allRecords();
    }

    public Set<String> dependentKeys() {
        return this.dependentKeys;
    }

    @Override
    public void willResolveRootQuery(Operation operation) {
        this.willResolveRecord(CacheKeyResolver.rootKeyForOperation(operation));
    }

    @Override
    public void willResolve(ResponseField field, Operation.Variables variables) {
        String key = field.cacheKey(variables);
        this.path.add(key);
    }

    @Override
    public void didResolve(ResponseField field, Operation.Variables variables) {
        this.path.remove(this.path.size() - 1);
        Object value = this.valueStack.pop();
        String cacheKey = field.cacheKey(variables);
        String dependentKey = this.currentRecordBuilder.key() + "." + cacheKey;
        this.dependentKeys.add(dependentKey);
        this.currentRecordBuilder.addField(cacheKey, value);
        if (this.recordStack.isEmpty()) {
            this.recordSet.merge(this.currentRecordBuilder.build());
        }
    }

    @Override
    public void didResolveScalar(@Nullable Object value) {
        this.valueStack.push(value);
    }

    @Override
    public void willResolveObject(ResponseField field, Optional<R> objectSource) {
        this.pathStack.push(this.path);
        CacheKey cacheKey = objectSource.isPresent() ? this.resolveCacheKey(field, objectSource.get()) : CacheKey.NO_KEY;
        String cacheKeyValue = cacheKey.key();
        if (cacheKey == CacheKey.NO_KEY) {
            cacheKeyValue = this.pathToString();
        } else {
            this.path = new ArrayList<String>();
            this.path.add(cacheKeyValue);
        }
        this.recordStack.push(this.currentRecordBuilder.build());
        this.currentRecordBuilder = Record.builder(cacheKeyValue);
    }

    @Override
    public void didResolveObject(ResponseField field, Optional<R> objectSource) {
        this.path = this.pathStack.pop();
        if (objectSource.isPresent()) {
            Record completedRecord = this.currentRecordBuilder.build();
            this.valueStack.push(new CacheReference(completedRecord.key()));
            this.dependentKeys.add(completedRecord.key());
            this.recordSet.merge(completedRecord);
        }
        this.currentRecordBuilder = this.recordStack.pop().toBuilder();
    }

    @Override
    public void didResolveList(List array) {
        ArrayList<Object> parsedArray = new ArrayList<Object>(array.size());
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            parsedArray.add(0, this.valueStack.pop());
        }
        this.valueStack.push(parsedArray);
    }

    @Override
    public void willResolveElement(int atIndex) {
        this.path.add(Integer.toString(atIndex));
    }

    @Override
    public void didResolveElement(int atIndex) {
        this.path.remove(this.path.size() - 1);
    }

    @Override
    public void didResolveNull() {
        this.valueStack.push(null);
    }

    @Nonnull
    public abstract CacheKey resolveCacheKey(@Nonnull ResponseField var1, @Nonnull R var2);

    void willResolveRecord(CacheKey cacheKey) {
        this.pathStack = new SimpleStack();
        this.recordStack = new SimpleStack();
        this.valueStack = new SimpleStack();
        this.dependentKeys = new HashSet<String>();
        this.path = new ArrayList<String>();
        this.currentRecordBuilder = Record.builder(cacheKey.key());
        this.recordSet = new RecordSet();
    }

    private String pathToString() {
        StringBuilder stringBuilder = new StringBuilder();
        int size = this.path.size();
        for (int i = 0; i < size; ++i) {
            String pathPiece = this.path.get(i);
            stringBuilder.append(pathPiece);
            if (i >= size - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }
}

