/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResumeProcessesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String autoScalingGroupName;
    private List<String> scalingProcesses = new ArrayList<String>();

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public ResumeProcessesRequest withAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
        return this;
    }

    public List<String> getScalingProcesses() {
        return this.scalingProcesses;
    }

    public void setScalingProcesses(Collection<String> scalingProcesses) {
        if (scalingProcesses == null) {
            this.scalingProcesses = null;
            return;
        }
        this.scalingProcesses = new ArrayList<String>(scalingProcesses);
    }

    public ResumeProcessesRequest withScalingProcesses(String ... scalingProcesses) {
        if (this.getScalingProcesses() == null) {
            this.scalingProcesses = new ArrayList<String>(scalingProcesses.length);
        }
        for (String value : scalingProcesses) {
            this.scalingProcesses.add(value);
        }
        return this;
    }

    public ResumeProcessesRequest withScalingProcesses(Collection<String> scalingProcesses) {
        this.setScalingProcesses(scalingProcesses);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: " + this.getAutoScalingGroupName() + ",");
        }
        if (this.getScalingProcesses() != null) {
            sb.append("ScalingProcesses: " + this.getScalingProcesses());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getScalingProcesses() == null ? 0 : this.getScalingProcesses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResumeProcessesRequest)) {
            return false;
        }
        ResumeProcessesRequest other = (ResumeProcessesRequest)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getScalingProcesses() == null ^ this.getScalingProcesses() == null) {
            return false;
        }
        return other.getScalingProcesses() == null || other.getScalingProcesses().equals(this.getScalingProcesses());
    }
}

