/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.services.autoscaling.model.Alarm;
import com.amazonaws.services.autoscaling.model.StepAdjustment;
import com.amazonaws.services.autoscaling.model.TargetTrackingConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScalingPolicy
implements Serializable {
    private String autoScalingGroupName;
    private String policyName;
    private String policyARN;
    private String policyType;
    private String adjustmentType;
    private Integer minAdjustmentStep;
    private Integer minAdjustmentMagnitude;
    private Integer scalingAdjustment;
    private Integer cooldown;
    private List<StepAdjustment> stepAdjustments = new ArrayList<StepAdjustment>();
    private String metricAggregationType;
    private Integer estimatedInstanceWarmup;
    private List<Alarm> alarms = new ArrayList<Alarm>();
    private TargetTrackingConfiguration targetTrackingConfiguration;

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public ScalingPolicy withAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
        return this;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public ScalingPolicy withPolicyName(String policyName) {
        this.policyName = policyName;
        return this;
    }

    public String getPolicyARN() {
        return this.policyARN;
    }

    public void setPolicyARN(String policyARN) {
        this.policyARN = policyARN;
    }

    public ScalingPolicy withPolicyARN(String policyARN) {
        this.policyARN = policyARN;
        return this;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public ScalingPolicy withPolicyType(String policyType) {
        this.policyType = policyType;
        return this;
    }

    public String getAdjustmentType() {
        return this.adjustmentType;
    }

    public void setAdjustmentType(String adjustmentType) {
        this.adjustmentType = adjustmentType;
    }

    public ScalingPolicy withAdjustmentType(String adjustmentType) {
        this.adjustmentType = adjustmentType;
        return this;
    }

    public Integer getMinAdjustmentStep() {
        return this.minAdjustmentStep;
    }

    public void setMinAdjustmentStep(Integer minAdjustmentStep) {
        this.minAdjustmentStep = minAdjustmentStep;
    }

    public ScalingPolicy withMinAdjustmentStep(Integer minAdjustmentStep) {
        this.minAdjustmentStep = minAdjustmentStep;
        return this;
    }

    public Integer getMinAdjustmentMagnitude() {
        return this.minAdjustmentMagnitude;
    }

    public void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
        this.minAdjustmentMagnitude = minAdjustmentMagnitude;
    }

    public ScalingPolicy withMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
        this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        return this;
    }

    public Integer getScalingAdjustment() {
        return this.scalingAdjustment;
    }

    public void setScalingAdjustment(Integer scalingAdjustment) {
        this.scalingAdjustment = scalingAdjustment;
    }

    public ScalingPolicy withScalingAdjustment(Integer scalingAdjustment) {
        this.scalingAdjustment = scalingAdjustment;
        return this;
    }

    public Integer getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(Integer cooldown) {
        this.cooldown = cooldown;
    }

    public ScalingPolicy withCooldown(Integer cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public List<StepAdjustment> getStepAdjustments() {
        return this.stepAdjustments;
    }

    public void setStepAdjustments(Collection<StepAdjustment> stepAdjustments) {
        if (stepAdjustments == null) {
            this.stepAdjustments = null;
            return;
        }
        this.stepAdjustments = new ArrayList<StepAdjustment>(stepAdjustments);
    }

    public ScalingPolicy withStepAdjustments(StepAdjustment ... stepAdjustments) {
        if (this.getStepAdjustments() == null) {
            this.stepAdjustments = new ArrayList<StepAdjustment>(stepAdjustments.length);
        }
        for (StepAdjustment value : stepAdjustments) {
            this.stepAdjustments.add(value);
        }
        return this;
    }

    public ScalingPolicy withStepAdjustments(Collection<StepAdjustment> stepAdjustments) {
        this.setStepAdjustments(stepAdjustments);
        return this;
    }

    public String getMetricAggregationType() {
        return this.metricAggregationType;
    }

    public void setMetricAggregationType(String metricAggregationType) {
        this.metricAggregationType = metricAggregationType;
    }

    public ScalingPolicy withMetricAggregationType(String metricAggregationType) {
        this.metricAggregationType = metricAggregationType;
        return this;
    }

    public Integer getEstimatedInstanceWarmup() {
        return this.estimatedInstanceWarmup;
    }

    public void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
        this.estimatedInstanceWarmup = estimatedInstanceWarmup;
    }

    public ScalingPolicy withEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
        this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        return this;
    }

    public List<Alarm> getAlarms() {
        return this.alarms;
    }

    public void setAlarms(Collection<Alarm> alarms) {
        if (alarms == null) {
            this.alarms = null;
            return;
        }
        this.alarms = new ArrayList<Alarm>(alarms);
    }

    public ScalingPolicy withAlarms(Alarm ... alarms) {
        if (this.getAlarms() == null) {
            this.alarms = new ArrayList<Alarm>(alarms.length);
        }
        for (Alarm value : alarms) {
            this.alarms.add(value);
        }
        return this;
    }

    public ScalingPolicy withAlarms(Collection<Alarm> alarms) {
        this.setAlarms(alarms);
        return this;
    }

    public TargetTrackingConfiguration getTargetTrackingConfiguration() {
        return this.targetTrackingConfiguration;
    }

    public void setTargetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
        this.targetTrackingConfiguration = targetTrackingConfiguration;
    }

    public ScalingPolicy withTargetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
        this.targetTrackingConfiguration = targetTrackingConfiguration;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: " + this.getAutoScalingGroupName() + ",");
        }
        if (this.getPolicyName() != null) {
            sb.append("PolicyName: " + this.getPolicyName() + ",");
        }
        if (this.getPolicyARN() != null) {
            sb.append("PolicyARN: " + this.getPolicyARN() + ",");
        }
        if (this.getPolicyType() != null) {
            sb.append("PolicyType: " + this.getPolicyType() + ",");
        }
        if (this.getAdjustmentType() != null) {
            sb.append("AdjustmentType: " + this.getAdjustmentType() + ",");
        }
        if (this.getMinAdjustmentStep() != null) {
            sb.append("MinAdjustmentStep: " + this.getMinAdjustmentStep() + ",");
        }
        if (this.getMinAdjustmentMagnitude() != null) {
            sb.append("MinAdjustmentMagnitude: " + this.getMinAdjustmentMagnitude() + ",");
        }
        if (this.getScalingAdjustment() != null) {
            sb.append("ScalingAdjustment: " + this.getScalingAdjustment() + ",");
        }
        if (this.getCooldown() != null) {
            sb.append("Cooldown: " + this.getCooldown() + ",");
        }
        if (this.getStepAdjustments() != null) {
            sb.append("StepAdjustments: " + this.getStepAdjustments() + ",");
        }
        if (this.getMetricAggregationType() != null) {
            sb.append("MetricAggregationType: " + this.getMetricAggregationType() + ",");
        }
        if (this.getEstimatedInstanceWarmup() != null) {
            sb.append("EstimatedInstanceWarmup: " + this.getEstimatedInstanceWarmup() + ",");
        }
        if (this.getAlarms() != null) {
            sb.append("Alarms: " + this.getAlarms() + ",");
        }
        if (this.getTargetTrackingConfiguration() != null) {
            sb.append("TargetTrackingConfiguration: " + this.getTargetTrackingConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyName() == null ? 0 : this.getPolicyName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyARN() == null ? 0 : this.getPolicyARN().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyType() == null ? 0 : this.getPolicyType().hashCode());
        hashCode = 31 * hashCode + (this.getAdjustmentType() == null ? 0 : this.getAdjustmentType().hashCode());
        hashCode = 31 * hashCode + (this.getMinAdjustmentStep() == null ? 0 : this.getMinAdjustmentStep().hashCode());
        hashCode = 31 * hashCode + (this.getMinAdjustmentMagnitude() == null ? 0 : this.getMinAdjustmentMagnitude().hashCode());
        hashCode = 31 * hashCode + (this.getScalingAdjustment() == null ? 0 : this.getScalingAdjustment().hashCode());
        hashCode = 31 * hashCode + (this.getCooldown() == null ? 0 : this.getCooldown().hashCode());
        hashCode = 31 * hashCode + (this.getStepAdjustments() == null ? 0 : this.getStepAdjustments().hashCode());
        hashCode = 31 * hashCode + (this.getMetricAggregationType() == null ? 0 : this.getMetricAggregationType().hashCode());
        hashCode = 31 * hashCode + (this.getEstimatedInstanceWarmup() == null ? 0 : this.getEstimatedInstanceWarmup().hashCode());
        hashCode = 31 * hashCode + (this.getAlarms() == null ? 0 : this.getAlarms().hashCode());
        hashCode = 31 * hashCode + (this.getTargetTrackingConfiguration() == null ? 0 : this.getTargetTrackingConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getPolicyName() == null ^ this.getPolicyName() == null) {
            return false;
        }
        if (other.getPolicyName() != null && !other.getPolicyName().equals(this.getPolicyName())) {
            return false;
        }
        if (other.getPolicyARN() == null ^ this.getPolicyARN() == null) {
            return false;
        }
        if (other.getPolicyARN() != null && !other.getPolicyARN().equals(this.getPolicyARN())) {
            return false;
        }
        if (other.getPolicyType() == null ^ this.getPolicyType() == null) {
            return false;
        }
        if (other.getPolicyType() != null && !other.getPolicyType().equals(this.getPolicyType())) {
            return false;
        }
        if (other.getAdjustmentType() == null ^ this.getAdjustmentType() == null) {
            return false;
        }
        if (other.getAdjustmentType() != null && !other.getAdjustmentType().equals(this.getAdjustmentType())) {
            return false;
        }
        if (other.getMinAdjustmentStep() == null ^ this.getMinAdjustmentStep() == null) {
            return false;
        }
        if (other.getMinAdjustmentStep() != null && !other.getMinAdjustmentStep().equals(this.getMinAdjustmentStep())) {
            return false;
        }
        if (other.getMinAdjustmentMagnitude() == null ^ this.getMinAdjustmentMagnitude() == null) {
            return false;
        }
        if (other.getMinAdjustmentMagnitude() != null && !other.getMinAdjustmentMagnitude().equals(this.getMinAdjustmentMagnitude())) {
            return false;
        }
        if (other.getScalingAdjustment() == null ^ this.getScalingAdjustment() == null) {
            return false;
        }
        if (other.getScalingAdjustment() != null && !other.getScalingAdjustment().equals(this.getScalingAdjustment())) {
            return false;
        }
        if (other.getCooldown() == null ^ this.getCooldown() == null) {
            return false;
        }
        if (other.getCooldown() != null && !other.getCooldown().equals(this.getCooldown())) {
            return false;
        }
        if (other.getStepAdjustments() == null ^ this.getStepAdjustments() == null) {
            return false;
        }
        if (other.getStepAdjustments() != null && !other.getStepAdjustments().equals(this.getStepAdjustments())) {
            return false;
        }
        if (other.getMetricAggregationType() == null ^ this.getMetricAggregationType() == null) {
            return false;
        }
        if (other.getMetricAggregationType() != null && !other.getMetricAggregationType().equals(this.getMetricAggregationType())) {
            return false;
        }
        if (other.getEstimatedInstanceWarmup() == null ^ this.getEstimatedInstanceWarmup() == null) {
            return false;
        }
        if (other.getEstimatedInstanceWarmup() != null && !other.getEstimatedInstanceWarmup().equals(this.getEstimatedInstanceWarmup())) {
            return false;
        }
        if (other.getAlarms() == null ^ this.getAlarms() == null) {
            return false;
        }
        if (other.getAlarms() != null && !other.getAlarms().equals(this.getAlarms())) {
            return false;
        }
        if (other.getTargetTrackingConfiguration() == null ^ this.getTargetTrackingConfiguration() == null) {
            return false;
        }
        return other.getTargetTrackingConfiguration() == null || other.getTargetTrackingConfiguration().equals(this.getTargetTrackingConfiguration());
    }
}

