/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.BatchDeleteScheduledActionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class BatchDeleteScheduledActionRequestMarshaller
implements Marshaller<Request<BatchDeleteScheduledActionRequest>, BatchDeleteScheduledActionRequest> {
    public Request<BatchDeleteScheduledActionRequest> marshall(BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) {
        String prefix;
        if (batchDeleteScheduledActionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(BatchDeleteScheduledActionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchDeleteScheduledActionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "BatchDeleteScheduledAction");
        request.addParameter("Version", "2011-01-01");
        if (batchDeleteScheduledActionRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = batchDeleteScheduledActionRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (batchDeleteScheduledActionRequest.getScheduledActionNames() != null) {
            prefix = "ScheduledActionNames";
            List<String> scheduledActionNames = batchDeleteScheduledActionRequest.getScheduledActionNames();
            int scheduledActionNamesIndex = 1;
            String scheduledActionNamesPrefix = prefix;
            for (String scheduledActionNamesItem : scheduledActionNames) {
                prefix = scheduledActionNamesPrefix + ".member." + scheduledActionNamesIndex;
                if (scheduledActionNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)scheduledActionNamesItem));
                }
                ++scheduledActionNamesIndex;
            }
            String string = scheduledActionNamesPrefix;
        }
        return request;
    }
}

