/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest;
import com.amazonaws.services.autoscaling.model.ScheduledUpdateGroupActionRequest;
import com.amazonaws.services.autoscaling.model.transform.ScheduledUpdateGroupActionRequestStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class BatchPutScheduledUpdateGroupActionRequestMarshaller
implements Marshaller<Request<BatchPutScheduledUpdateGroupActionRequest>, BatchPutScheduledUpdateGroupActionRequest> {
    public Request<BatchPutScheduledUpdateGroupActionRequest> marshall(BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) {
        String prefix;
        if (batchPutScheduledUpdateGroupActionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(BatchPutScheduledUpdateGroupActionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchPutScheduledUpdateGroupActionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "BatchPutScheduledUpdateGroupAction");
        request.addParameter("Version", "2011-01-01");
        if (batchPutScheduledUpdateGroupActionRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = batchPutScheduledUpdateGroupActionRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (batchPutScheduledUpdateGroupActionRequest.getScheduledUpdateGroupActions() != null) {
            prefix = "ScheduledUpdateGroupActions";
            List<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActions = batchPutScheduledUpdateGroupActionRequest.getScheduledUpdateGroupActions();
            int scheduledUpdateGroupActionsIndex = 1;
            String scheduledUpdateGroupActionsPrefix = prefix;
            for (ScheduledUpdateGroupActionRequest scheduledUpdateGroupActionsItem : scheduledUpdateGroupActions) {
                prefix = scheduledUpdateGroupActionsPrefix + ".member." + scheduledUpdateGroupActionsIndex;
                if (scheduledUpdateGroupActionsItem != null) {
                    ScheduledUpdateGroupActionRequestStaxMarshaller.getInstance().marshall(scheduledUpdateGroupActionsItem, (Request<?>)request, prefix + ".");
                }
                ++scheduledUpdateGroupActionsIndex;
            }
            String string = scheduledUpdateGroupActionsPrefix;
        }
        return request;
    }
}

