/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.Ebs;
import com.amazonaws.services.autoscaling.model.transform.EbsStaxMarshaller;
import com.amazonaws.util.StringUtils;

class BlockDeviceMappingStaxMarshaller {
    private static BlockDeviceMappingStaxMarshaller instance;

    BlockDeviceMappingStaxMarshaller() {
    }

    public void marshall(BlockDeviceMapping _blockDeviceMapping, Request<?> request, String _prefix) {
        String prefix;
        if (_blockDeviceMapping.getVirtualName() != null) {
            prefix = _prefix + "VirtualName";
            String virtualName = _blockDeviceMapping.getVirtualName();
            request.addParameter(prefix, StringUtils.fromString((String)virtualName));
        }
        if (_blockDeviceMapping.getDeviceName() != null) {
            prefix = _prefix + "DeviceName";
            String deviceName = _blockDeviceMapping.getDeviceName();
            request.addParameter(prefix, StringUtils.fromString((String)deviceName));
        }
        if (_blockDeviceMapping.getEbs() != null) {
            prefix = _prefix + "Ebs";
            Ebs ebs = _blockDeviceMapping.getEbs();
            EbsStaxMarshaller.getInstance().marshall(ebs, request, prefix + ".");
        }
        if (_blockDeviceMapping.getNoDevice() != null) {
            prefix = _prefix + "NoDevice";
            Boolean noDevice = _blockDeviceMapping.getNoDevice();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)noDevice));
        }
    }

    public static BlockDeviceMappingStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new BlockDeviceMappingStaxMarshaller();
        }
        return instance;
    }
}

