/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.CustomizedMetricSpecification;
import com.amazonaws.services.autoscaling.model.MetricDimension;
import com.amazonaws.services.autoscaling.model.transform.MetricDimensionStaxMarshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

class CustomizedMetricSpecificationStaxMarshaller {
    private static CustomizedMetricSpecificationStaxMarshaller instance;

    CustomizedMetricSpecificationStaxMarshaller() {
    }

    public void marshall(CustomizedMetricSpecification _customizedMetricSpecification, Request<?> request, String _prefix) {
        String prefix;
        if (_customizedMetricSpecification.getMetricName() != null) {
            prefix = _prefix + "MetricName";
            String metricName = _customizedMetricSpecification.getMetricName();
            request.addParameter(prefix, StringUtils.fromString((String)metricName));
        }
        if (_customizedMetricSpecification.getNamespace() != null) {
            prefix = _prefix + "Namespace";
            String namespace = _customizedMetricSpecification.getNamespace();
            request.addParameter(prefix, StringUtils.fromString((String)namespace));
        }
        if (_customizedMetricSpecification.getDimensions() != null) {
            prefix = _prefix + "Dimensions";
            List<MetricDimension> dimensions = _customizedMetricSpecification.getDimensions();
            int dimensionsIndex = 1;
            String dimensionsPrefix = prefix;
            for (MetricDimension dimensionsItem : dimensions) {
                prefix = dimensionsPrefix + ".member." + dimensionsIndex;
                if (dimensionsItem != null) {
                    MetricDimensionStaxMarshaller.getInstance().marshall(dimensionsItem, request, prefix + ".");
                }
                ++dimensionsIndex;
            }
            prefix = dimensionsPrefix;
        }
        if (_customizedMetricSpecification.getStatistic() != null) {
            prefix = _prefix + "Statistic";
            String statistic = _customizedMetricSpecification.getStatistic();
            request.addParameter(prefix, StringUtils.fromString((String)statistic));
        }
        if (_customizedMetricSpecification.getUnit() != null) {
            prefix = _prefix + "Unit";
            String unit = _customizedMetricSpecification.getUnit();
            request.addParameter(prefix, StringUtils.fromString((String)unit));
        }
    }

    public static CustomizedMetricSpecificationStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new CustomizedMetricSpecificationStaxMarshaller();
        }
        return instance;
    }
}

