/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DeletePolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeletePolicyRequestMarshaller
implements Marshaller<Request<DeletePolicyRequest>, DeletePolicyRequest> {
    public Request<DeletePolicyRequest> marshall(DeletePolicyRequest deletePolicyRequest) {
        String prefix;
        if (deletePolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeletePolicyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deletePolicyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DeletePolicy");
        request.addParameter("Version", "2011-01-01");
        if (deletePolicyRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = deletePolicyRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (deletePolicyRequest.getPolicyName() != null) {
            prefix = "PolicyName";
            String policyName = deletePolicyRequest.getPolicyName();
            request.addParameter(prefix, StringUtils.fromString((String)policyName));
        }
        return request;
    }
}

