/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeAutoScalingInstancesRequestMarshaller
implements Marshaller<Request<DescribeAutoScalingInstancesRequest>, DescribeAutoScalingInstancesRequest> {
    public Request<DescribeAutoScalingInstancesRequest> marshall(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        String prefix;
        if (describeAutoScalingInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeAutoScalingInstancesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAutoScalingInstancesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeAutoScalingInstances");
        request.addParameter("Version", "2011-01-01");
        if (describeAutoScalingInstancesRequest.getInstanceIds() != null) {
            prefix = "InstanceIds";
            List<String> instanceIds = describeAutoScalingInstancesRequest.getInstanceIds();
            int instanceIdsIndex = 1;
            String instanceIdsPrefix = prefix;
            for (String instanceIdsItem : instanceIds) {
                prefix = instanceIdsPrefix + ".member." + instanceIdsIndex;
                if (instanceIdsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)instanceIdsItem));
                }
                ++instanceIdsIndex;
            }
            prefix = instanceIdsPrefix;
        }
        if (describeAutoScalingInstancesRequest.getMaxRecords() != null) {
            prefix = "MaxRecords";
            Integer maxRecords = describeAutoScalingInstancesRequest.getMaxRecords();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxRecords));
        }
        if (describeAutoScalingInstancesRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = describeAutoScalingInstancesRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        return request;
    }
}

