/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeLaunchConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeLaunchConfigurationsRequest>, DescribeLaunchConfigurationsRequest> {
    public Request<DescribeLaunchConfigurationsRequest> marshall(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        String prefix;
        if (describeLaunchConfigurationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeLaunchConfigurationsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLaunchConfigurationsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeLaunchConfigurations");
        request.addParameter("Version", "2011-01-01");
        if (describeLaunchConfigurationsRequest.getLaunchConfigurationNames() != null) {
            prefix = "LaunchConfigurationNames";
            List<String> launchConfigurationNames = describeLaunchConfigurationsRequest.getLaunchConfigurationNames();
            int launchConfigurationNamesIndex = 1;
            String launchConfigurationNamesPrefix = prefix;
            for (String launchConfigurationNamesItem : launchConfigurationNames) {
                prefix = launchConfigurationNamesPrefix + ".member." + launchConfigurationNamesIndex;
                if (launchConfigurationNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)launchConfigurationNamesItem));
                }
                ++launchConfigurationNamesIndex;
            }
            prefix = launchConfigurationNamesPrefix;
        }
        if (describeLaunchConfigurationsRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = describeLaunchConfigurationsRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        if (describeLaunchConfigurationsRequest.getMaxRecords() != null) {
            prefix = "MaxRecords";
            Integer maxRecords = describeLaunchConfigurationsRequest.getMaxRecords();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxRecords));
        }
        return request;
    }
}

