/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeLifecycleHooksRequestMarshaller
implements Marshaller<Request<DescribeLifecycleHooksRequest>, DescribeLifecycleHooksRequest> {
    public Request<DescribeLifecycleHooksRequest> marshall(DescribeLifecycleHooksRequest describeLifecycleHooksRequest) {
        String prefix;
        if (describeLifecycleHooksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeLifecycleHooksRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLifecycleHooksRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeLifecycleHooks");
        request.addParameter("Version", "2011-01-01");
        if (describeLifecycleHooksRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = describeLifecycleHooksRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (describeLifecycleHooksRequest.getLifecycleHookNames() != null) {
            prefix = "LifecycleHookNames";
            List<String> lifecycleHookNames = describeLifecycleHooksRequest.getLifecycleHookNames();
            int lifecycleHookNamesIndex = 1;
            String lifecycleHookNamesPrefix = prefix;
            for (String lifecycleHookNamesItem : lifecycleHookNames) {
                prefix = lifecycleHookNamesPrefix + ".member." + lifecycleHookNamesIndex;
                if (lifecycleHookNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)lifecycleHookNamesItem));
                }
                ++lifecycleHookNamesIndex;
            }
            String string = lifecycleHookNamesPrefix;
        }
        return request;
    }
}

