/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeNotificationConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeNotificationConfigurationsRequest>, DescribeNotificationConfigurationsRequest> {
    public Request<DescribeNotificationConfigurationsRequest> marshall(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        String prefix;
        if (describeNotificationConfigurationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeNotificationConfigurationsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeNotificationConfigurationsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeNotificationConfigurations");
        request.addParameter("Version", "2011-01-01");
        if (describeNotificationConfigurationsRequest.getAutoScalingGroupNames() != null) {
            prefix = "AutoScalingGroupNames";
            List<String> autoScalingGroupNames = describeNotificationConfigurationsRequest.getAutoScalingGroupNames();
            int autoScalingGroupNamesIndex = 1;
            String autoScalingGroupNamesPrefix = prefix;
            for (String autoScalingGroupNamesItem : autoScalingGroupNames) {
                prefix = autoScalingGroupNamesPrefix + ".member." + autoScalingGroupNamesIndex;
                if (autoScalingGroupNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupNamesItem));
                }
                ++autoScalingGroupNamesIndex;
            }
            prefix = autoScalingGroupNamesPrefix;
        }
        if (describeNotificationConfigurationsRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = describeNotificationConfigurationsRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        if (describeNotificationConfigurationsRequest.getMaxRecords() != null) {
            prefix = "MaxRecords";
            Integer maxRecords = describeNotificationConfigurationsRequest.getMaxRecords();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxRecords));
        }
        return request;
    }
}

