/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribePoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribePoliciesRequestMarshaller
implements Marshaller<Request<DescribePoliciesRequest>, DescribePoliciesRequest> {
    public Request<DescribePoliciesRequest> marshall(DescribePoliciesRequest describePoliciesRequest) {
        String prefix;
        if (describePoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribePoliciesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describePoliciesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribePolicies");
        request.addParameter("Version", "2011-01-01");
        if (describePoliciesRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = describePoliciesRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (describePoliciesRequest.getPolicyNames() != null) {
            prefix = "PolicyNames";
            List<String> policyNames = describePoliciesRequest.getPolicyNames();
            int policyNamesIndex = 1;
            String policyNamesPrefix = prefix;
            for (String policyNamesItem : policyNames) {
                prefix = policyNamesPrefix + ".member." + policyNamesIndex;
                if (policyNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)policyNamesItem));
                }
                ++policyNamesIndex;
            }
            prefix = policyNamesPrefix;
        }
        if (describePoliciesRequest.getPolicyTypes() != null) {
            prefix = "PolicyTypes";
            List<String> policyTypes = describePoliciesRequest.getPolicyTypes();
            int policyTypesIndex = 1;
            String policyTypesPrefix = prefix;
            for (String policyTypesItem : policyTypes) {
                prefix = policyTypesPrefix + ".member." + policyTypesIndex;
                if (policyTypesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)policyTypesItem));
                }
                ++policyTypesIndex;
            }
            prefix = policyTypesPrefix;
        }
        if (describePoliciesRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = describePoliciesRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        if (describePoliciesRequest.getMaxRecords() != null) {
            prefix = "MaxRecords";
            Integer maxRecords = describePoliciesRequest.getMaxRecords();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxRecords));
        }
        return request;
    }
}

