/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

public class DescribeScheduledActionsRequestMarshaller
implements Marshaller<Request<DescribeScheduledActionsRequest>, DescribeScheduledActionsRequest> {
    public Request<DescribeScheduledActionsRequest> marshall(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        String prefix;
        if (describeScheduledActionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeScheduledActionsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeScheduledActionsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeScheduledActions");
        request.addParameter("Version", "2011-01-01");
        if (describeScheduledActionsRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = describeScheduledActionsRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (describeScheduledActionsRequest.getScheduledActionNames() != null) {
            prefix = "ScheduledActionNames";
            List<String> scheduledActionNames = describeScheduledActionsRequest.getScheduledActionNames();
            int scheduledActionNamesIndex = 1;
            String scheduledActionNamesPrefix = prefix;
            for (String scheduledActionNamesItem : scheduledActionNames) {
                prefix = scheduledActionNamesPrefix + ".member." + scheduledActionNamesIndex;
                if (scheduledActionNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)scheduledActionNamesItem));
                }
                ++scheduledActionNamesIndex;
            }
            prefix = scheduledActionNamesPrefix;
        }
        if (describeScheduledActionsRequest.getStartTime() != null) {
            prefix = "StartTime";
            Date startTime = describeScheduledActionsRequest.getStartTime();
            request.addParameter(prefix, StringUtils.fromDate((Date)startTime));
        }
        if (describeScheduledActionsRequest.getEndTime() != null) {
            prefix = "EndTime";
            Date endTime = describeScheduledActionsRequest.getEndTime();
            request.addParameter(prefix, StringUtils.fromDate((Date)endTime));
        }
        if (describeScheduledActionsRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = describeScheduledActionsRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        if (describeScheduledActionsRequest.getMaxRecords() != null) {
            prefix = "MaxRecords";
            Integer maxRecords = describeScheduledActionsRequest.getMaxRecords();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxRecords));
        }
        return request;
    }
}

