/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeTagsRequest;
import com.amazonaws.services.autoscaling.model.Filter;
import com.amazonaws.services.autoscaling.model.transform.FilterStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeTagsRequestMarshaller
implements Marshaller<Request<DescribeTagsRequest>, DescribeTagsRequest> {
    public Request<DescribeTagsRequest> marshall(DescribeTagsRequest describeTagsRequest) {
        String prefix;
        if (describeTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeTagsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTagsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeTags");
        request.addParameter("Version", "2011-01-01");
        if (describeTagsRequest.getFilters() != null) {
            prefix = "Filters";
            List<Filter> filters = describeTagsRequest.getFilters();
            int filtersIndex = 1;
            String filtersPrefix = prefix;
            for (Filter filtersItem : filters) {
                prefix = filtersPrefix + ".member." + filtersIndex;
                if (filtersItem != null) {
                    FilterStaxMarshaller.getInstance().marshall(filtersItem, (Request<?>)request, prefix + ".");
                }
                ++filtersIndex;
            }
            prefix = filtersPrefix;
        }
        if (describeTagsRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = describeTagsRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        if (describeTagsRequest.getMaxRecords() != null) {
            prefix = "MaxRecords";
            Integer maxRecords = describeTagsRequest.getMaxRecords();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxRecords));
        }
        return request;
    }
}

