/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DetachInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DetachInstancesRequestMarshaller
implements Marshaller<Request<DetachInstancesRequest>, DetachInstancesRequest> {
    public Request<DetachInstancesRequest> marshall(DetachInstancesRequest detachInstancesRequest) {
        String prefix;
        if (detachInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DetachInstancesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachInstancesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DetachInstances");
        request.addParameter("Version", "2011-01-01");
        if (detachInstancesRequest.getInstanceIds() != null) {
            prefix = "InstanceIds";
            List<String> instanceIds = detachInstancesRequest.getInstanceIds();
            int instanceIdsIndex = 1;
            String instanceIdsPrefix = prefix;
            for (String instanceIdsItem : instanceIds) {
                prefix = instanceIdsPrefix + ".member." + instanceIdsIndex;
                if (instanceIdsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)instanceIdsItem));
                }
                ++instanceIdsIndex;
            }
            prefix = instanceIdsPrefix;
        }
        if (detachInstancesRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = detachInstancesRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (detachInstancesRequest.getShouldDecrementDesiredCapacity() != null) {
            prefix = "ShouldDecrementDesiredCapacity";
            Boolean shouldDecrementDesiredCapacity = detachInstancesRequest.getShouldDecrementDesiredCapacity();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)shouldDecrementDesiredCapacity));
        }
        return request;
    }
}

