/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DetachLoadBalancerTargetGroupsRequestMarshaller
implements Marshaller<Request<DetachLoadBalancerTargetGroupsRequest>, DetachLoadBalancerTargetGroupsRequest> {
    public Request<DetachLoadBalancerTargetGroupsRequest> marshall(DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) {
        String prefix;
        if (detachLoadBalancerTargetGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DetachLoadBalancerTargetGroupsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachLoadBalancerTargetGroupsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DetachLoadBalancerTargetGroups");
        request.addParameter("Version", "2011-01-01");
        if (detachLoadBalancerTargetGroupsRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = detachLoadBalancerTargetGroupsRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (detachLoadBalancerTargetGroupsRequest.getTargetGroupARNs() != null) {
            prefix = "TargetGroupARNs";
            List<String> targetGroupARNs = detachLoadBalancerTargetGroupsRequest.getTargetGroupARNs();
            int targetGroupARNsIndex = 1;
            String targetGroupARNsPrefix = prefix;
            for (String targetGroupARNsItem : targetGroupARNs) {
                prefix = targetGroupARNsPrefix + ".member." + targetGroupARNsIndex;
                if (targetGroupARNsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)targetGroupARNsItem));
                }
                ++targetGroupARNsIndex;
            }
            String string = targetGroupARNsPrefix;
        }
        return request;
    }
}

