/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class EnableMetricsCollectionRequestMarshaller
implements Marshaller<Request<EnableMetricsCollectionRequest>, EnableMetricsCollectionRequest> {
    public Request<EnableMetricsCollectionRequest> marshall(EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        String prefix;
        if (enableMetricsCollectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(EnableMetricsCollectionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableMetricsCollectionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "EnableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        if (enableMetricsCollectionRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = enableMetricsCollectionRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (enableMetricsCollectionRequest.getMetrics() != null) {
            prefix = "Metrics";
            List<String> metrics = enableMetricsCollectionRequest.getMetrics();
            int metricsIndex = 1;
            String metricsPrefix = prefix;
            for (String metricsItem : metrics) {
                prefix = metricsPrefix + ".member." + metricsIndex;
                if (metricsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)metricsItem));
                }
                ++metricsIndex;
            }
            prefix = metricsPrefix;
        }
        if (enableMetricsCollectionRequest.getGranularity() != null) {
            prefix = "Granularity";
            String granularity = enableMetricsCollectionRequest.getGranularity();
            request.addParameter(prefix, StringUtils.fromString((String)granularity));
        }
        return request;
    }
}

