/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.ExecutePolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ExecutePolicyRequestMarshaller
implements Marshaller<Request<ExecutePolicyRequest>, ExecutePolicyRequest> {
    public Request<ExecutePolicyRequest> marshall(ExecutePolicyRequest executePolicyRequest) {
        String prefix;
        if (executePolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ExecutePolicyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)executePolicyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "ExecutePolicy");
        request.addParameter("Version", "2011-01-01");
        if (executePolicyRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = executePolicyRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (executePolicyRequest.getPolicyName() != null) {
            prefix = "PolicyName";
            String policyName = executePolicyRequest.getPolicyName();
            request.addParameter(prefix, StringUtils.fromString((String)policyName));
        }
        if (executePolicyRequest.getHonorCooldown() != null) {
            prefix = "HonorCooldown";
            Boolean honorCooldown = executePolicyRequest.getHonorCooldown();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)honorCooldown));
        }
        if (executePolicyRequest.getMetricValue() != null) {
            prefix = "MetricValue";
            Double metricValue = executePolicyRequest.getMetricValue();
            request.addParameter(prefix, StringUtils.fromDouble((Double)metricValue));
        }
        if (executePolicyRequest.getBreachThreshold() != null) {
            prefix = "BreachThreshold";
            Double breachThreshold = executePolicyRequest.getBreachThreshold();
            request.addParameter(prefix, StringUtils.fromDouble((Double)breachThreshold));
        }
        return request;
    }
}

