/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.ExitStandbyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ExitStandbyRequestMarshaller
implements Marshaller<Request<ExitStandbyRequest>, ExitStandbyRequest> {
    public Request<ExitStandbyRequest> marshall(ExitStandbyRequest exitStandbyRequest) {
        String prefix;
        if (exitStandbyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ExitStandbyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)exitStandbyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "ExitStandby");
        request.addParameter("Version", "2011-01-01");
        if (exitStandbyRequest.getInstanceIds() != null) {
            prefix = "InstanceIds";
            List<String> instanceIds = exitStandbyRequest.getInstanceIds();
            int instanceIdsIndex = 1;
            String instanceIdsPrefix = prefix;
            for (String instanceIdsItem : instanceIds) {
                prefix = instanceIdsPrefix + ".member." + instanceIdsIndex;
                if (instanceIdsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)instanceIdsItem));
                }
                ++instanceIdsIndex;
            }
            prefix = instanceIdsPrefix;
        }
        if (exitStandbyRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = exitStandbyRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        return request;
    }
}

