/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.LaunchTemplate;
import com.amazonaws.services.autoscaling.model.transform.LaunchTemplateOverridesStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.LaunchTemplateSpecificationStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

class LaunchTemplateStaxUnmarshaller
implements Unmarshaller<LaunchTemplate, StaxUnmarshallerContext> {
    private static LaunchTemplateStaxUnmarshaller instance;

    LaunchTemplateStaxUnmarshaller() {
    }

    public LaunchTemplate unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        LaunchTemplate launchTemplate = new LaunchTemplate();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (context.testExpression("LaunchTemplateSpecification", targetDepth)) {
                    launchTemplate.setLaunchTemplateSpecification(LaunchTemplateSpecificationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Overrides/member", targetDepth)) continue;
                launchTemplate.withOverrides(LaunchTemplateOverridesStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return launchTemplate;
    }

    public static LaunchTemplateStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LaunchTemplateStaxUnmarshaller();
        }
        return instance;
    }
}

