/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.PutLifecycleHookRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutLifecycleHookRequestMarshaller
implements Marshaller<Request<PutLifecycleHookRequest>, PutLifecycleHookRequest> {
    public Request<PutLifecycleHookRequest> marshall(PutLifecycleHookRequest putLifecycleHookRequest) {
        String prefix;
        if (putLifecycleHookRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PutLifecycleHookRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putLifecycleHookRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutLifecycleHook");
        request.addParameter("Version", "2011-01-01");
        if (putLifecycleHookRequest.getLifecycleHookName() != null) {
            prefix = "LifecycleHookName";
            String lifecycleHookName = putLifecycleHookRequest.getLifecycleHookName();
            request.addParameter(prefix, StringUtils.fromString((String)lifecycleHookName));
        }
        if (putLifecycleHookRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = putLifecycleHookRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (putLifecycleHookRequest.getLifecycleTransition() != null) {
            prefix = "LifecycleTransition";
            String lifecycleTransition = putLifecycleHookRequest.getLifecycleTransition();
            request.addParameter(prefix, StringUtils.fromString((String)lifecycleTransition));
        }
        if (putLifecycleHookRequest.getRoleARN() != null) {
            prefix = "RoleARN";
            String roleARN = putLifecycleHookRequest.getRoleARN();
            request.addParameter(prefix, StringUtils.fromString((String)roleARN));
        }
        if (putLifecycleHookRequest.getNotificationTargetARN() != null) {
            prefix = "NotificationTargetARN";
            String notificationTargetARN = putLifecycleHookRequest.getNotificationTargetARN();
            request.addParameter(prefix, StringUtils.fromString((String)notificationTargetARN));
        }
        if (putLifecycleHookRequest.getNotificationMetadata() != null) {
            prefix = "NotificationMetadata";
            String notificationMetadata = putLifecycleHookRequest.getNotificationMetadata();
            request.addParameter(prefix, StringUtils.fromString((String)notificationMetadata));
        }
        if (putLifecycleHookRequest.getHeartbeatTimeout() != null) {
            prefix = "HeartbeatTimeout";
            Integer heartbeatTimeout = putLifecycleHookRequest.getHeartbeatTimeout();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)heartbeatTimeout));
        }
        if (putLifecycleHookRequest.getDefaultResult() != null) {
            prefix = "DefaultResult";
            String defaultResult = putLifecycleHookRequest.getDefaultResult();
            request.addParameter(prefix, StringUtils.fromString((String)defaultResult));
        }
        return request;
    }
}

