/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.autoscaling.model.StepAdjustment;
import com.amazonaws.services.autoscaling.model.TargetTrackingConfiguration;
import com.amazonaws.services.autoscaling.model.transform.StepAdjustmentStaxMarshaller;
import com.amazonaws.services.autoscaling.model.transform.TargetTrackingConfigurationStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class PutScalingPolicyRequestMarshaller
implements Marshaller<Request<PutScalingPolicyRequest>, PutScalingPolicyRequest> {
    public Request<PutScalingPolicyRequest> marshall(PutScalingPolicyRequest putScalingPolicyRequest) {
        String prefix;
        if (putScalingPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PutScalingPolicyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putScalingPolicyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutScalingPolicy");
        request.addParameter("Version", "2011-01-01");
        if (putScalingPolicyRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = putScalingPolicyRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (putScalingPolicyRequest.getPolicyName() != null) {
            prefix = "PolicyName";
            String policyName = putScalingPolicyRequest.getPolicyName();
            request.addParameter(prefix, StringUtils.fromString((String)policyName));
        }
        if (putScalingPolicyRequest.getPolicyType() != null) {
            prefix = "PolicyType";
            String policyType = putScalingPolicyRequest.getPolicyType();
            request.addParameter(prefix, StringUtils.fromString((String)policyType));
        }
        if (putScalingPolicyRequest.getAdjustmentType() != null) {
            prefix = "AdjustmentType";
            String adjustmentType = putScalingPolicyRequest.getAdjustmentType();
            request.addParameter(prefix, StringUtils.fromString((String)adjustmentType));
        }
        if (putScalingPolicyRequest.getMinAdjustmentStep() != null) {
            prefix = "MinAdjustmentStep";
            Integer minAdjustmentStep = putScalingPolicyRequest.getMinAdjustmentStep();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)minAdjustmentStep));
        }
        if (putScalingPolicyRequest.getMinAdjustmentMagnitude() != null) {
            prefix = "MinAdjustmentMagnitude";
            Integer minAdjustmentMagnitude = putScalingPolicyRequest.getMinAdjustmentMagnitude();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)minAdjustmentMagnitude));
        }
        if (putScalingPolicyRequest.getScalingAdjustment() != null) {
            prefix = "ScalingAdjustment";
            Integer scalingAdjustment = putScalingPolicyRequest.getScalingAdjustment();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)scalingAdjustment));
        }
        if (putScalingPolicyRequest.getCooldown() != null) {
            prefix = "Cooldown";
            Integer cooldown = putScalingPolicyRequest.getCooldown();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)cooldown));
        }
        if (putScalingPolicyRequest.getMetricAggregationType() != null) {
            prefix = "MetricAggregationType";
            String metricAggregationType = putScalingPolicyRequest.getMetricAggregationType();
            request.addParameter(prefix, StringUtils.fromString((String)metricAggregationType));
        }
        if (putScalingPolicyRequest.getStepAdjustments() != null) {
            prefix = "StepAdjustments";
            List<StepAdjustment> stepAdjustments = putScalingPolicyRequest.getStepAdjustments();
            int stepAdjustmentsIndex = 1;
            String stepAdjustmentsPrefix = prefix;
            for (StepAdjustment stepAdjustmentsItem : stepAdjustments) {
                prefix = stepAdjustmentsPrefix + ".member." + stepAdjustmentsIndex;
                if (stepAdjustmentsItem != null) {
                    StepAdjustmentStaxMarshaller.getInstance().marshall(stepAdjustmentsItem, (Request<?>)request, prefix + ".");
                }
                ++stepAdjustmentsIndex;
            }
            prefix = stepAdjustmentsPrefix;
        }
        if (putScalingPolicyRequest.getEstimatedInstanceWarmup() != null) {
            prefix = "EstimatedInstanceWarmup";
            Integer estimatedInstanceWarmup = putScalingPolicyRequest.getEstimatedInstanceWarmup();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)estimatedInstanceWarmup));
        }
        if (putScalingPolicyRequest.getTargetTrackingConfiguration() != null) {
            prefix = "TargetTrackingConfiguration";
            TargetTrackingConfiguration targetTrackingConfiguration = putScalingPolicyRequest.getTargetTrackingConfiguration();
            TargetTrackingConfigurationStaxMarshaller.getInstance().marshall(targetTrackingConfiguration, (Request<?>)request, prefix + ".");
        }
        return request;
    }
}

