/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.ResumeProcessesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ResumeProcessesRequestMarshaller
implements Marshaller<Request<ResumeProcessesRequest>, ResumeProcessesRequest> {
    public Request<ResumeProcessesRequest> marshall(ResumeProcessesRequest resumeProcessesRequest) {
        String prefix;
        if (resumeProcessesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ResumeProcessesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resumeProcessesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "ResumeProcesses");
        request.addParameter("Version", "2011-01-01");
        if (resumeProcessesRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = resumeProcessesRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (resumeProcessesRequest.getScalingProcesses() != null) {
            prefix = "ScalingProcesses";
            List<String> scalingProcesses = resumeProcessesRequest.getScalingProcesses();
            int scalingProcessesIndex = 1;
            String scalingProcessesPrefix = prefix;
            for (String scalingProcessesItem : scalingProcesses) {
                prefix = scalingProcessesPrefix + ".member." + scalingProcessesIndex;
                if (scalingProcessesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)scalingProcessesItem));
                }
                ++scalingProcessesIndex;
            }
            String string = scalingProcessesPrefix;
        }
        return request;
    }
}

