/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SetInstanceProtectionRequestMarshaller
implements Marshaller<Request<SetInstanceProtectionRequest>, SetInstanceProtectionRequest> {
    public Request<SetInstanceProtectionRequest> marshall(SetInstanceProtectionRequest setInstanceProtectionRequest) {
        String prefix;
        if (setInstanceProtectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetInstanceProtectionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setInstanceProtectionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "SetInstanceProtection");
        request.addParameter("Version", "2011-01-01");
        if (setInstanceProtectionRequest.getInstanceIds() != null) {
            prefix = "InstanceIds";
            List<String> instanceIds = setInstanceProtectionRequest.getInstanceIds();
            int instanceIdsIndex = 1;
            String instanceIdsPrefix = prefix;
            for (String instanceIdsItem : instanceIds) {
                prefix = instanceIdsPrefix + ".member." + instanceIdsIndex;
                if (instanceIdsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)instanceIdsItem));
                }
                ++instanceIdsIndex;
            }
            prefix = instanceIdsPrefix;
        }
        if (setInstanceProtectionRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = setInstanceProtectionRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (setInstanceProtectionRequest.getProtectedFromScaleIn() != null) {
            prefix = "ProtectedFromScaleIn";
            Boolean protectedFromScaleIn = setInstanceProtectionRequest.getProtectedFromScaleIn();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)protectedFromScaleIn));
        }
        return request;
    }
}

