/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.SuspendProcessesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SuspendProcessesRequestMarshaller
implements Marshaller<Request<SuspendProcessesRequest>, SuspendProcessesRequest> {
    public Request<SuspendProcessesRequest> marshall(SuspendProcessesRequest suspendProcessesRequest) {
        String prefix;
        if (suspendProcessesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SuspendProcessesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)suspendProcessesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "SuspendProcesses");
        request.addParameter("Version", "2011-01-01");
        if (suspendProcessesRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = suspendProcessesRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (suspendProcessesRequest.getScalingProcesses() != null) {
            prefix = "ScalingProcesses";
            List<String> scalingProcesses = suspendProcessesRequest.getScalingProcesses();
            int scalingProcessesIndex = 1;
            String scalingProcessesPrefix = prefix;
            for (String scalingProcessesItem : scalingProcesses) {
                prefix = scalingProcessesPrefix + ".member." + scalingProcessesIndex;
                if (scalingProcessesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)scalingProcessesItem));
                }
                ++scalingProcessesIndex;
            }
            String string = scalingProcessesPrefix;
        }
        return request;
    }
}

