/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.services.autoscaling.model.EnabledMetric;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.autoscaling.model.SuspendedProcess;
import com.amazonaws.services.autoscaling.model.TagDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AutoScalingGroup
implements Serializable {
    private String autoScalingGroupName;
    private String autoScalingGroupARN;
    private String launchConfigurationName;
    private LaunchTemplateSpecification launchTemplate;
    private Integer minSize;
    private Integer maxSize;
    private Integer desiredCapacity;
    private Integer defaultCooldown;
    private List<String> availabilityZones = new ArrayList<String>();
    private List<String> loadBalancerNames = new ArrayList<String>();
    private List<String> targetGroupARNs = new ArrayList<String>();
    private String healthCheckType;
    private Integer healthCheckGracePeriod;
    private List<Instance> instances = new ArrayList<Instance>();
    private Date createdTime;
    private List<SuspendedProcess> suspendedProcesses = new ArrayList<SuspendedProcess>();
    private String placementGroup;
    private String vPCZoneIdentifier;
    private List<EnabledMetric> enabledMetrics = new ArrayList<EnabledMetric>();
    private String status;
    private List<TagDescription> tags = new ArrayList<TagDescription>();
    private List<String> terminationPolicies = new ArrayList<String>();
    private Boolean newInstancesProtectedFromScaleIn;
    private String serviceLinkedRoleARN;

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public AutoScalingGroup withAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
        return this;
    }

    public String getAutoScalingGroupARN() {
        return this.autoScalingGroupARN;
    }

    public void setAutoScalingGroupARN(String autoScalingGroupARN) {
        this.autoScalingGroupARN = autoScalingGroupARN;
    }

    public AutoScalingGroup withAutoScalingGroupARN(String autoScalingGroupARN) {
        this.autoScalingGroupARN = autoScalingGroupARN;
        return this;
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public void setLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
    }

    public AutoScalingGroup withLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
        return this;
    }

    public LaunchTemplateSpecification getLaunchTemplate() {
        return this.launchTemplate;
    }

    public void setLaunchTemplate(LaunchTemplateSpecification launchTemplate) {
        this.launchTemplate = launchTemplate;
    }

    public AutoScalingGroup withLaunchTemplate(LaunchTemplateSpecification launchTemplate) {
        this.launchTemplate = launchTemplate;
        return this;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    public AutoScalingGroup withMinSize(Integer minSize) {
        this.minSize = minSize;
        return this;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public AutoScalingGroup withMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public Integer getDesiredCapacity() {
        return this.desiredCapacity;
    }

    public void setDesiredCapacity(Integer desiredCapacity) {
        this.desiredCapacity = desiredCapacity;
    }

    public AutoScalingGroup withDesiredCapacity(Integer desiredCapacity) {
        this.desiredCapacity = desiredCapacity;
        return this;
    }

    public Integer getDefaultCooldown() {
        return this.defaultCooldown;
    }

    public void setDefaultCooldown(Integer defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
    }

    public AutoScalingGroup withDefaultCooldown(Integer defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
        return this;
    }

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new ArrayList<String>(availabilityZones);
    }

    public AutoScalingGroup withAvailabilityZones(String ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.availabilityZones = new ArrayList<String>(availabilityZones.length);
        }
        for (String value : availabilityZones) {
            this.availabilityZones.add(value);
        }
        return this;
    }

    public AutoScalingGroup withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public List<String> getLoadBalancerNames() {
        return this.loadBalancerNames;
    }

    public void setLoadBalancerNames(Collection<String> loadBalancerNames) {
        if (loadBalancerNames == null) {
            this.loadBalancerNames = null;
            return;
        }
        this.loadBalancerNames = new ArrayList<String>(loadBalancerNames);
    }

    public AutoScalingGroup withLoadBalancerNames(String ... loadBalancerNames) {
        if (this.getLoadBalancerNames() == null) {
            this.loadBalancerNames = new ArrayList<String>(loadBalancerNames.length);
        }
        for (String value : loadBalancerNames) {
            this.loadBalancerNames.add(value);
        }
        return this;
    }

    public AutoScalingGroup withLoadBalancerNames(Collection<String> loadBalancerNames) {
        this.setLoadBalancerNames(loadBalancerNames);
        return this;
    }

    public List<String> getTargetGroupARNs() {
        return this.targetGroupARNs;
    }

    public void setTargetGroupARNs(Collection<String> targetGroupARNs) {
        if (targetGroupARNs == null) {
            this.targetGroupARNs = null;
            return;
        }
        this.targetGroupARNs = new ArrayList<String>(targetGroupARNs);
    }

    public AutoScalingGroup withTargetGroupARNs(String ... targetGroupARNs) {
        if (this.getTargetGroupARNs() == null) {
            this.targetGroupARNs = new ArrayList<String>(targetGroupARNs.length);
        }
        for (String value : targetGroupARNs) {
            this.targetGroupARNs.add(value);
        }
        return this;
    }

    public AutoScalingGroup withTargetGroupARNs(Collection<String> targetGroupARNs) {
        this.setTargetGroupARNs(targetGroupARNs);
        return this;
    }

    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    public void setHealthCheckType(String healthCheckType) {
        this.healthCheckType = healthCheckType;
    }

    public AutoScalingGroup withHealthCheckType(String healthCheckType) {
        this.healthCheckType = healthCheckType;
        return this;
    }

    public Integer getHealthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
        this.healthCheckGracePeriod = healthCheckGracePeriod;
    }

    public AutoScalingGroup withHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
        this.healthCheckGracePeriod = healthCheckGracePeriod;
        return this;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new ArrayList<Instance>(instances);
    }

    public AutoScalingGroup withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.instances = new ArrayList<Instance>(instances.length);
        }
        for (Instance value : instances) {
            this.instances.add(value);
        }
        return this;
    }

    public AutoScalingGroup withInstances(Collection<Instance> instances) {
        this.setInstances(instances);
        return this;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public AutoScalingGroup withCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public List<SuspendedProcess> getSuspendedProcesses() {
        return this.suspendedProcesses;
    }

    public void setSuspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
        if (suspendedProcesses == null) {
            this.suspendedProcesses = null;
            return;
        }
        this.suspendedProcesses = new ArrayList<SuspendedProcess>(suspendedProcesses);
    }

    public AutoScalingGroup withSuspendedProcesses(SuspendedProcess ... suspendedProcesses) {
        if (this.getSuspendedProcesses() == null) {
            this.suspendedProcesses = new ArrayList<SuspendedProcess>(suspendedProcesses.length);
        }
        for (SuspendedProcess value : suspendedProcesses) {
            this.suspendedProcesses.add(value);
        }
        return this;
    }

    public AutoScalingGroup withSuspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
        this.setSuspendedProcesses(suspendedProcesses);
        return this;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public void setPlacementGroup(String placementGroup) {
        this.placementGroup = placementGroup;
    }

    public AutoScalingGroup withPlacementGroup(String placementGroup) {
        this.placementGroup = placementGroup;
        return this;
    }

    public String getVPCZoneIdentifier() {
        return this.vPCZoneIdentifier;
    }

    public void setVPCZoneIdentifier(String vPCZoneIdentifier) {
        this.vPCZoneIdentifier = vPCZoneIdentifier;
    }

    public AutoScalingGroup withVPCZoneIdentifier(String vPCZoneIdentifier) {
        this.vPCZoneIdentifier = vPCZoneIdentifier;
        return this;
    }

    public List<EnabledMetric> getEnabledMetrics() {
        return this.enabledMetrics;
    }

    public void setEnabledMetrics(Collection<EnabledMetric> enabledMetrics) {
        if (enabledMetrics == null) {
            this.enabledMetrics = null;
            return;
        }
        this.enabledMetrics = new ArrayList<EnabledMetric>(enabledMetrics);
    }

    public AutoScalingGroup withEnabledMetrics(EnabledMetric ... enabledMetrics) {
        if (this.getEnabledMetrics() == null) {
            this.enabledMetrics = new ArrayList<EnabledMetric>(enabledMetrics.length);
        }
        for (EnabledMetric value : enabledMetrics) {
            this.enabledMetrics.add(value);
        }
        return this;
    }

    public AutoScalingGroup withEnabledMetrics(Collection<EnabledMetric> enabledMetrics) {
        this.setEnabledMetrics(enabledMetrics);
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AutoScalingGroup withStatus(String status) {
        this.status = status;
        return this;
    }

    public List<TagDescription> getTags() {
        return this.tags;
    }

    public void setTags(Collection<TagDescription> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<TagDescription>(tags);
    }

    public AutoScalingGroup withTags(TagDescription ... tags) {
        if (this.getTags() == null) {
            this.tags = new ArrayList<TagDescription>(tags.length);
        }
        for (TagDescription value : tags) {
            this.tags.add(value);
        }
        return this;
    }

    public AutoScalingGroup withTags(Collection<TagDescription> tags) {
        this.setTags(tags);
        return this;
    }

    public List<String> getTerminationPolicies() {
        return this.terminationPolicies;
    }

    public void setTerminationPolicies(Collection<String> terminationPolicies) {
        if (terminationPolicies == null) {
            this.terminationPolicies = null;
            return;
        }
        this.terminationPolicies = new ArrayList<String>(terminationPolicies);
    }

    public AutoScalingGroup withTerminationPolicies(String ... terminationPolicies) {
        if (this.getTerminationPolicies() == null) {
            this.terminationPolicies = new ArrayList<String>(terminationPolicies.length);
        }
        for (String value : terminationPolicies) {
            this.terminationPolicies.add(value);
        }
        return this;
    }

    public AutoScalingGroup withTerminationPolicies(Collection<String> terminationPolicies) {
        this.setTerminationPolicies(terminationPolicies);
        return this;
    }

    public Boolean isNewInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public Boolean getNewInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
        this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
    }

    public AutoScalingGroup withNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
        this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        return this;
    }

    public String getServiceLinkedRoleARN() {
        return this.serviceLinkedRoleARN;
    }

    public void setServiceLinkedRoleARN(String serviceLinkedRoleARN) {
        this.serviceLinkedRoleARN = serviceLinkedRoleARN;
    }

    public AutoScalingGroup withServiceLinkedRoleARN(String serviceLinkedRoleARN) {
        this.serviceLinkedRoleARN = serviceLinkedRoleARN;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: " + this.getAutoScalingGroupName() + ",");
        }
        if (this.getAutoScalingGroupARN() != null) {
            sb.append("AutoScalingGroupARN: " + this.getAutoScalingGroupARN() + ",");
        }
        if (this.getLaunchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: " + this.getLaunchConfigurationName() + ",");
        }
        if (this.getLaunchTemplate() != null) {
            sb.append("LaunchTemplate: " + this.getLaunchTemplate() + ",");
        }
        if (this.getMinSize() != null) {
            sb.append("MinSize: " + this.getMinSize() + ",");
        }
        if (this.getMaxSize() != null) {
            sb.append("MaxSize: " + this.getMaxSize() + ",");
        }
        if (this.getDesiredCapacity() != null) {
            sb.append("DesiredCapacity: " + this.getDesiredCapacity() + ",");
        }
        if (this.getDefaultCooldown() != null) {
            sb.append("DefaultCooldown: " + this.getDefaultCooldown() + ",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: " + this.getAvailabilityZones() + ",");
        }
        if (this.getLoadBalancerNames() != null) {
            sb.append("LoadBalancerNames: " + this.getLoadBalancerNames() + ",");
        }
        if (this.getTargetGroupARNs() != null) {
            sb.append("TargetGroupARNs: " + this.getTargetGroupARNs() + ",");
        }
        if (this.getHealthCheckType() != null) {
            sb.append("HealthCheckType: " + this.getHealthCheckType() + ",");
        }
        if (this.getHealthCheckGracePeriod() != null) {
            sb.append("HealthCheckGracePeriod: " + this.getHealthCheckGracePeriod() + ",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances() + ",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: " + this.getCreatedTime() + ",");
        }
        if (this.getSuspendedProcesses() != null) {
            sb.append("SuspendedProcesses: " + this.getSuspendedProcesses() + ",");
        }
        if (this.getPlacementGroup() != null) {
            sb.append("PlacementGroup: " + this.getPlacementGroup() + ",");
        }
        if (this.getVPCZoneIdentifier() != null) {
            sb.append("VPCZoneIdentifier: " + this.getVPCZoneIdentifier() + ",");
        }
        if (this.getEnabledMetrics() != null) {
            sb.append("EnabledMetrics: " + this.getEnabledMetrics() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getTerminationPolicies() != null) {
            sb.append("TerminationPolicies: " + this.getTerminationPolicies() + ",");
        }
        if (this.getNewInstancesProtectedFromScaleIn() != null) {
            sb.append("NewInstancesProtectedFromScaleIn: " + this.getNewInstancesProtectedFromScaleIn() + ",");
        }
        if (this.getServiceLinkedRoleARN() != null) {
            sb.append("ServiceLinkedRoleARN: " + this.getServiceLinkedRoleARN());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroupARN() == null ? 0 : this.getAutoScalingGroupARN().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchConfigurationName() == null ? 0 : this.getLaunchConfigurationName().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTemplate() == null ? 0 : this.getLaunchTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getMinSize() == null ? 0 : this.getMinSize().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSize() == null ? 0 : this.getMaxSize().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredCapacity() == null ? 0 : this.getDesiredCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultCooldown() == null ? 0 : this.getDefaultCooldown().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerNames() == null ? 0 : this.getLoadBalancerNames().hashCode());
        hashCode = 31 * hashCode + (this.getTargetGroupARNs() == null ? 0 : this.getTargetGroupARNs().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckType() == null ? 0 : this.getHealthCheckType().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckGracePeriod() == null ? 0 : this.getHealthCheckGracePeriod().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getSuspendedProcesses() == null ? 0 : this.getSuspendedProcesses().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementGroup() == null ? 0 : this.getPlacementGroup().hashCode());
        hashCode = 31 * hashCode + (this.getVPCZoneIdentifier() == null ? 0 : this.getVPCZoneIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getEnabledMetrics() == null ? 0 : this.getEnabledMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTerminationPolicies() == null ? 0 : this.getTerminationPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getNewInstancesProtectedFromScaleIn() == null ? 0 : this.getNewInstancesProtectedFromScaleIn().hashCode());
        hashCode = 31 * hashCode + (this.getServiceLinkedRoleARN() == null ? 0 : this.getServiceLinkedRoleARN().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getAutoScalingGroupARN() == null ^ this.getAutoScalingGroupARN() == null) {
            return false;
        }
        if (other.getAutoScalingGroupARN() != null && !other.getAutoScalingGroupARN().equals(this.getAutoScalingGroupARN())) {
            return false;
        }
        if (other.getLaunchConfigurationName() == null ^ this.getLaunchConfigurationName() == null) {
            return false;
        }
        if (other.getLaunchConfigurationName() != null && !other.getLaunchConfigurationName().equals(this.getLaunchConfigurationName())) {
            return false;
        }
        if (other.getLaunchTemplate() == null ^ this.getLaunchTemplate() == null) {
            return false;
        }
        if (other.getLaunchTemplate() != null && !other.getLaunchTemplate().equals(this.getLaunchTemplate())) {
            return false;
        }
        if (other.getMinSize() == null ^ this.getMinSize() == null) {
            return false;
        }
        if (other.getMinSize() != null && !other.getMinSize().equals(this.getMinSize())) {
            return false;
        }
        if (other.getMaxSize() == null ^ this.getMaxSize() == null) {
            return false;
        }
        if (other.getMaxSize() != null && !other.getMaxSize().equals(this.getMaxSize())) {
            return false;
        }
        if (other.getDesiredCapacity() == null ^ this.getDesiredCapacity() == null) {
            return false;
        }
        if (other.getDesiredCapacity() != null && !other.getDesiredCapacity().equals(this.getDesiredCapacity())) {
            return false;
        }
        if (other.getDefaultCooldown() == null ^ this.getDefaultCooldown() == null) {
            return false;
        }
        if (other.getDefaultCooldown() != null && !other.getDefaultCooldown().equals(this.getDefaultCooldown())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getLoadBalancerNames() == null ^ this.getLoadBalancerNames() == null) {
            return false;
        }
        if (other.getLoadBalancerNames() != null && !other.getLoadBalancerNames().equals(this.getLoadBalancerNames())) {
            return false;
        }
        if (other.getTargetGroupARNs() == null ^ this.getTargetGroupARNs() == null) {
            return false;
        }
        if (other.getTargetGroupARNs() != null && !other.getTargetGroupARNs().equals(this.getTargetGroupARNs())) {
            return false;
        }
        if (other.getHealthCheckType() == null ^ this.getHealthCheckType() == null) {
            return false;
        }
        if (other.getHealthCheckType() != null && !other.getHealthCheckType().equals(this.getHealthCheckType())) {
            return false;
        }
        if (other.getHealthCheckGracePeriod() == null ^ this.getHealthCheckGracePeriod() == null) {
            return false;
        }
        if (other.getHealthCheckGracePeriod() != null && !other.getHealthCheckGracePeriod().equals(this.getHealthCheckGracePeriod())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getSuspendedProcesses() == null ^ this.getSuspendedProcesses() == null) {
            return false;
        }
        if (other.getSuspendedProcesses() != null && !other.getSuspendedProcesses().equals(this.getSuspendedProcesses())) {
            return false;
        }
        if (other.getPlacementGroup() == null ^ this.getPlacementGroup() == null) {
            return false;
        }
        if (other.getPlacementGroup() != null && !other.getPlacementGroup().equals(this.getPlacementGroup())) {
            return false;
        }
        if (other.getVPCZoneIdentifier() == null ^ this.getVPCZoneIdentifier() == null) {
            return false;
        }
        if (other.getVPCZoneIdentifier() != null && !other.getVPCZoneIdentifier().equals(this.getVPCZoneIdentifier())) {
            return false;
        }
        if (other.getEnabledMetrics() == null ^ this.getEnabledMetrics() == null) {
            return false;
        }
        if (other.getEnabledMetrics() != null && !other.getEnabledMetrics().equals(this.getEnabledMetrics())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTerminationPolicies() == null ^ this.getTerminationPolicies() == null) {
            return false;
        }
        if (other.getTerminationPolicies() != null && !other.getTerminationPolicies().equals(this.getTerminationPolicies())) {
            return false;
        }
        if (other.getNewInstancesProtectedFromScaleIn() == null ^ this.getNewInstancesProtectedFromScaleIn() == null) {
            return false;
        }
        if (other.getNewInstancesProtectedFromScaleIn() != null && !other.getNewInstancesProtectedFromScaleIn().equals(this.getNewInstancesProtectedFromScaleIn())) {
            return false;
        }
        if (other.getServiceLinkedRoleARN() == null ^ this.getServiceLinkedRoleARN() == null) {
            return false;
        }
        return other.getServiceLinkedRoleARN() == null || other.getServiceLinkedRoleARN().equals(this.getServiceLinkedRoleARN());
    }
}

