/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.services.autoscaling.model.MetricDimension;
import com.amazonaws.services.autoscaling.model.MetricStatistic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomizedMetricSpecification
implements Serializable {
    private String metricName;
    private String namespace;
    private List<MetricDimension> dimensions = new ArrayList<MetricDimension>();
    private String statistic;
    private String unit;

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public CustomizedMetricSpecification withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public CustomizedMetricSpecification withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public List<MetricDimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<MetricDimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new ArrayList<MetricDimension>(dimensions);
    }

    public CustomizedMetricSpecification withDimensions(MetricDimension ... dimensions) {
        if (this.getDimensions() == null) {
            this.dimensions = new ArrayList<MetricDimension>(dimensions.length);
        }
        for (MetricDimension value : dimensions) {
            this.dimensions.add(value);
        }
        return this;
    }

    public CustomizedMetricSpecification withDimensions(Collection<MetricDimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public String getStatistic() {
        return this.statistic;
    }

    public void setStatistic(String statistic) {
        this.statistic = statistic;
    }

    public CustomizedMetricSpecification withStatistic(String statistic) {
        this.statistic = statistic;
        return this;
    }

    public void setStatistic(MetricStatistic statistic) {
        this.statistic = statistic.toString();
    }

    public CustomizedMetricSpecification withStatistic(MetricStatistic statistic) {
        this.statistic = statistic.toString();
        return this;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public CustomizedMetricSpecification withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricName() != null) {
            sb.append("MetricName: " + this.getMetricName() + ",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: " + this.getNamespace() + ",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: " + this.getDimensions() + ",");
        }
        if (this.getStatistic() != null) {
            sb.append("Statistic: " + this.getStatistic() + ",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: " + this.getUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getStatistic() == null ? 0 : this.getStatistic().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomizedMetricSpecification)) {
            return false;
        }
        CustomizedMetricSpecification other = (CustomizedMetricSpecification)obj;
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getStatistic() == null ^ this.getStatistic() == null) {
            return false;
        }
        if (other.getStatistic() != null && !other.getStatistic().equals(this.getStatistic())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        return other.getUnit() == null || other.getUnit().equals(this.getUnit());
    }
}

