/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.AttachInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AttachInstancesRequestMarshaller
implements Marshaller<Request<AttachInstancesRequest>, AttachInstancesRequest> {
    public Request<AttachInstancesRequest> marshall(AttachInstancesRequest attachInstancesRequest) {
        String prefix;
        if (attachInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AttachInstancesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachInstancesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "AttachInstances");
        request.addParameter("Version", "2011-01-01");
        if (attachInstancesRequest.getInstanceIds() != null) {
            prefix = "InstanceIds";
            List<String> instanceIds = attachInstancesRequest.getInstanceIds();
            int instanceIdsIndex = 1;
            String instanceIdsPrefix = prefix;
            for (String instanceIdsItem : instanceIds) {
                prefix = instanceIdsPrefix + ".member." + instanceIdsIndex;
                if (instanceIdsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)instanceIdsItem));
                }
                ++instanceIdsIndex;
            }
            prefix = instanceIdsPrefix;
        }
        if (attachInstancesRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = attachInstancesRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        return request;
    }
}

