/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AttachLoadBalancerTargetGroupsRequestMarshaller
implements Marshaller<Request<AttachLoadBalancerTargetGroupsRequest>, AttachLoadBalancerTargetGroupsRequest> {
    public Request<AttachLoadBalancerTargetGroupsRequest> marshall(AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) {
        String prefix;
        if (attachLoadBalancerTargetGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AttachLoadBalancerTargetGroupsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachLoadBalancerTargetGroupsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "AttachLoadBalancerTargetGroups");
        request.addParameter("Version", "2011-01-01");
        if (attachLoadBalancerTargetGroupsRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = attachLoadBalancerTargetGroupsRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (attachLoadBalancerTargetGroupsRequest.getTargetGroupARNs() != null) {
            prefix = "TargetGroupARNs";
            List<String> targetGroupARNs = attachLoadBalancerTargetGroupsRequest.getTargetGroupARNs();
            int targetGroupARNsIndex = 1;
            String targetGroupARNsPrefix = prefix;
            for (String targetGroupARNsItem : targetGroupARNs) {
                prefix = targetGroupARNsPrefix + ".member." + targetGroupARNsIndex;
                if (targetGroupARNsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)targetGroupARNsItem));
                }
                ++targetGroupARNsIndex;
            }
            String string = targetGroupARNsPrefix;
        }
        return request;
    }
}

