/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CompleteLifecycleActionRequestMarshaller
implements Marshaller<Request<CompleteLifecycleActionRequest>, CompleteLifecycleActionRequest> {
    public Request<CompleteLifecycleActionRequest> marshall(CompleteLifecycleActionRequest completeLifecycleActionRequest) {
        String prefix;
        if (completeLifecycleActionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CompleteLifecycleActionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)completeLifecycleActionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "CompleteLifecycleAction");
        request.addParameter("Version", "2011-01-01");
        if (completeLifecycleActionRequest.getLifecycleHookName() != null) {
            prefix = "LifecycleHookName";
            String lifecycleHookName = completeLifecycleActionRequest.getLifecycleHookName();
            request.addParameter(prefix, StringUtils.fromString((String)lifecycleHookName));
        }
        if (completeLifecycleActionRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = completeLifecycleActionRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (completeLifecycleActionRequest.getLifecycleActionToken() != null) {
            prefix = "LifecycleActionToken";
            String lifecycleActionToken = completeLifecycleActionRequest.getLifecycleActionToken();
            request.addParameter(prefix, StringUtils.fromString((String)lifecycleActionToken));
        }
        if (completeLifecycleActionRequest.getLifecycleActionResult() != null) {
            prefix = "LifecycleActionResult";
            String lifecycleActionResult = completeLifecycleActionRequest.getLifecycleActionResult();
            request.addParameter(prefix, StringUtils.fromString((String)lifecycleActionResult));
        }
        if (completeLifecycleActionRequest.getInstanceId() != null) {
            prefix = "InstanceId";
            String instanceId = completeLifecycleActionRequest.getInstanceId();
            request.addParameter(prefix, StringUtils.fromString((String)instanceId));
        }
        return request;
    }
}

