/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.autoscaling.model.LifecycleHookSpecification;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.services.autoscaling.model.transform.LaunchTemplateSpecificationStaxMarshaller;
import com.amazonaws.services.autoscaling.model.transform.LifecycleHookSpecificationStaxMarshaller;
import com.amazonaws.services.autoscaling.model.transform.TagStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<CreateAutoScalingGroupRequest>, CreateAutoScalingGroupRequest> {
    public Request<CreateAutoScalingGroupRequest> marshall(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {
        String prefix;
        if (createAutoScalingGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateAutoScalingGroupRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAutoScalingGroupRequest, "AmazonAutoScaling");
        request.addParameter("Action", "CreateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        if (createAutoScalingGroupRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = createAutoScalingGroupRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (createAutoScalingGroupRequest.getLaunchConfigurationName() != null) {
            prefix = "LaunchConfigurationName";
            String launchConfigurationName = createAutoScalingGroupRequest.getLaunchConfigurationName();
            request.addParameter(prefix, StringUtils.fromString((String)launchConfigurationName));
        }
        if (createAutoScalingGroupRequest.getLaunchTemplate() != null) {
            prefix = "LaunchTemplate";
            LaunchTemplateSpecification launchTemplate = createAutoScalingGroupRequest.getLaunchTemplate();
            LaunchTemplateSpecificationStaxMarshaller.getInstance().marshall(launchTemplate, (Request<?>)request, prefix + ".");
        }
        if (createAutoScalingGroupRequest.getInstanceId() != null) {
            prefix = "InstanceId";
            String instanceId = createAutoScalingGroupRequest.getInstanceId();
            request.addParameter(prefix, StringUtils.fromString((String)instanceId));
        }
        if (createAutoScalingGroupRequest.getMinSize() != null) {
            prefix = "MinSize";
            Integer minSize = createAutoScalingGroupRequest.getMinSize();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)minSize));
        }
        if (createAutoScalingGroupRequest.getMaxSize() != null) {
            prefix = "MaxSize";
            Integer maxSize = createAutoScalingGroupRequest.getMaxSize();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxSize));
        }
        if (createAutoScalingGroupRequest.getDesiredCapacity() != null) {
            prefix = "DesiredCapacity";
            Integer desiredCapacity = createAutoScalingGroupRequest.getDesiredCapacity();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)desiredCapacity));
        }
        if (createAutoScalingGroupRequest.getDefaultCooldown() != null) {
            prefix = "DefaultCooldown";
            Integer defaultCooldown = createAutoScalingGroupRequest.getDefaultCooldown();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)defaultCooldown));
        }
        if (createAutoScalingGroupRequest.getAvailabilityZones() != null) {
            prefix = "AvailabilityZones";
            List<String> availabilityZones = createAutoScalingGroupRequest.getAvailabilityZones();
            int availabilityZonesIndex = 1;
            String availabilityZonesPrefix = prefix;
            for (String availabilityZonesItem : availabilityZones) {
                prefix = availabilityZonesPrefix + ".member." + availabilityZonesIndex;
                if (availabilityZonesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)availabilityZonesItem));
                }
                ++availabilityZonesIndex;
            }
            prefix = availabilityZonesPrefix;
        }
        if (createAutoScalingGroupRequest.getLoadBalancerNames() != null) {
            prefix = "LoadBalancerNames";
            List<String> loadBalancerNames = createAutoScalingGroupRequest.getLoadBalancerNames();
            int loadBalancerNamesIndex = 1;
            String loadBalancerNamesPrefix = prefix;
            for (String loadBalancerNamesItem : loadBalancerNames) {
                prefix = loadBalancerNamesPrefix + ".member." + loadBalancerNamesIndex;
                if (loadBalancerNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)loadBalancerNamesItem));
                }
                ++loadBalancerNamesIndex;
            }
            prefix = loadBalancerNamesPrefix;
        }
        if (createAutoScalingGroupRequest.getTargetGroupARNs() != null) {
            prefix = "TargetGroupARNs";
            List<String> targetGroupARNs = createAutoScalingGroupRequest.getTargetGroupARNs();
            int targetGroupARNsIndex = 1;
            String targetGroupARNsPrefix = prefix;
            for (String targetGroupARNsItem : targetGroupARNs) {
                prefix = targetGroupARNsPrefix + ".member." + targetGroupARNsIndex;
                if (targetGroupARNsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)targetGroupARNsItem));
                }
                ++targetGroupARNsIndex;
            }
            prefix = targetGroupARNsPrefix;
        }
        if (createAutoScalingGroupRequest.getHealthCheckType() != null) {
            prefix = "HealthCheckType";
            String healthCheckType = createAutoScalingGroupRequest.getHealthCheckType();
            request.addParameter(prefix, StringUtils.fromString((String)healthCheckType));
        }
        if (createAutoScalingGroupRequest.getHealthCheckGracePeriod() != null) {
            prefix = "HealthCheckGracePeriod";
            Integer healthCheckGracePeriod = createAutoScalingGroupRequest.getHealthCheckGracePeriod();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)healthCheckGracePeriod));
        }
        if (createAutoScalingGroupRequest.getPlacementGroup() != null) {
            prefix = "PlacementGroup";
            String placementGroup = createAutoScalingGroupRequest.getPlacementGroup();
            request.addParameter(prefix, StringUtils.fromString((String)placementGroup));
        }
        if (createAutoScalingGroupRequest.getVPCZoneIdentifier() != null) {
            prefix = "VPCZoneIdentifier";
            String vPCZoneIdentifier = createAutoScalingGroupRequest.getVPCZoneIdentifier();
            request.addParameter(prefix, StringUtils.fromString((String)vPCZoneIdentifier));
        }
        if (createAutoScalingGroupRequest.getTerminationPolicies() != null) {
            prefix = "TerminationPolicies";
            List<String> terminationPolicies = createAutoScalingGroupRequest.getTerminationPolicies();
            int terminationPoliciesIndex = 1;
            String terminationPoliciesPrefix = prefix;
            for (String terminationPoliciesItem : terminationPolicies) {
                prefix = terminationPoliciesPrefix + ".member." + terminationPoliciesIndex;
                if (terminationPoliciesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)terminationPoliciesItem));
                }
                ++terminationPoliciesIndex;
            }
            prefix = terminationPoliciesPrefix;
        }
        if (createAutoScalingGroupRequest.getNewInstancesProtectedFromScaleIn() != null) {
            prefix = "NewInstancesProtectedFromScaleIn";
            Boolean newInstancesProtectedFromScaleIn = createAutoScalingGroupRequest.getNewInstancesProtectedFromScaleIn();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)newInstancesProtectedFromScaleIn));
        }
        if (createAutoScalingGroupRequest.getLifecycleHookSpecificationList() != null) {
            prefix = "LifecycleHookSpecificationList";
            List<LifecycleHookSpecification> lifecycleHookSpecificationList = createAutoScalingGroupRequest.getLifecycleHookSpecificationList();
            int lifecycleHookSpecificationListIndex = 1;
            String lifecycleHookSpecificationListPrefix = prefix;
            for (LifecycleHookSpecification lifecycleHookSpecificationListItem : lifecycleHookSpecificationList) {
                prefix = lifecycleHookSpecificationListPrefix + ".member." + lifecycleHookSpecificationListIndex;
                if (lifecycleHookSpecificationListItem != null) {
                    LifecycleHookSpecificationStaxMarshaller.getInstance().marshall(lifecycleHookSpecificationListItem, (Request<?>)request, prefix + ".");
                }
                ++lifecycleHookSpecificationListIndex;
            }
            prefix = lifecycleHookSpecificationListPrefix;
        }
        if (createAutoScalingGroupRequest.getTags() != null) {
            prefix = "Tags";
            List<Tag> tags = createAutoScalingGroupRequest.getTags();
            int tagsIndex = 1;
            String tagsPrefix = prefix;
            for (Tag tagsItem : tags) {
                prefix = tagsPrefix + ".member." + tagsIndex;
                if (tagsItem != null) {
                    TagStaxMarshaller.getInstance().marshall(tagsItem, (Request<?>)request, prefix + ".");
                }
                ++tagsIndex;
            }
            prefix = tagsPrefix;
        }
        if (createAutoScalingGroupRequest.getServiceLinkedRoleARN() != null) {
            prefix = "ServiceLinkedRoleARN";
            String serviceLinkedRoleARN = createAutoScalingGroupRequest.getServiceLinkedRoleARN();
            request.addParameter(prefix, StringUtils.fromString((String)serviceLinkedRoleARN));
        }
        return request;
    }
}

