/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.InstanceMonitoring;
import com.amazonaws.services.autoscaling.model.transform.BlockDeviceMappingStaxMarshaller;
import com.amazonaws.services.autoscaling.model.transform.InstanceMonitoringStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateLaunchConfigurationRequestMarshaller
implements Marshaller<Request<CreateLaunchConfigurationRequest>, CreateLaunchConfigurationRequest> {
    public Request<CreateLaunchConfigurationRequest> marshall(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {
        String prefix;
        if (createLaunchConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateLaunchConfigurationRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLaunchConfigurationRequest, "AmazonAutoScaling");
        request.addParameter("Action", "CreateLaunchConfiguration");
        request.addParameter("Version", "2011-01-01");
        if (createLaunchConfigurationRequest.getLaunchConfigurationName() != null) {
            prefix = "LaunchConfigurationName";
            String launchConfigurationName = createLaunchConfigurationRequest.getLaunchConfigurationName();
            request.addParameter(prefix, StringUtils.fromString((String)launchConfigurationName));
        }
        if (createLaunchConfigurationRequest.getImageId() != null) {
            prefix = "ImageId";
            String imageId = createLaunchConfigurationRequest.getImageId();
            request.addParameter(prefix, StringUtils.fromString((String)imageId));
        }
        if (createLaunchConfigurationRequest.getKeyName() != null) {
            prefix = "KeyName";
            String keyName = createLaunchConfigurationRequest.getKeyName();
            request.addParameter(prefix, StringUtils.fromString((String)keyName));
        }
        if (createLaunchConfigurationRequest.getSecurityGroups() != null) {
            prefix = "SecurityGroups";
            List<String> securityGroups = createLaunchConfigurationRequest.getSecurityGroups();
            int securityGroupsIndex = 1;
            String securityGroupsPrefix = prefix;
            for (String securityGroupsItem : securityGroups) {
                prefix = securityGroupsPrefix + ".member." + securityGroupsIndex;
                if (securityGroupsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)securityGroupsItem));
                }
                ++securityGroupsIndex;
            }
            prefix = securityGroupsPrefix;
        }
        if (createLaunchConfigurationRequest.getClassicLinkVPCId() != null) {
            prefix = "ClassicLinkVPCId";
            String classicLinkVPCId = createLaunchConfigurationRequest.getClassicLinkVPCId();
            request.addParameter(prefix, StringUtils.fromString((String)classicLinkVPCId));
        }
        if (createLaunchConfigurationRequest.getClassicLinkVPCSecurityGroups() != null) {
            prefix = "ClassicLinkVPCSecurityGroups";
            List<String> classicLinkVPCSecurityGroups = createLaunchConfigurationRequest.getClassicLinkVPCSecurityGroups();
            int classicLinkVPCSecurityGroupsIndex = 1;
            String classicLinkVPCSecurityGroupsPrefix = prefix;
            for (String classicLinkVPCSecurityGroupsItem : classicLinkVPCSecurityGroups) {
                prefix = classicLinkVPCSecurityGroupsPrefix + ".member." + classicLinkVPCSecurityGroupsIndex;
                if (classicLinkVPCSecurityGroupsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)classicLinkVPCSecurityGroupsItem));
                }
                ++classicLinkVPCSecurityGroupsIndex;
            }
            prefix = classicLinkVPCSecurityGroupsPrefix;
        }
        if (createLaunchConfigurationRequest.getUserData() != null) {
            prefix = "UserData";
            String userData = createLaunchConfigurationRequest.getUserData();
            request.addParameter(prefix, StringUtils.fromString((String)userData));
        }
        if (createLaunchConfigurationRequest.getInstanceId() != null) {
            prefix = "InstanceId";
            String instanceId = createLaunchConfigurationRequest.getInstanceId();
            request.addParameter(prefix, StringUtils.fromString((String)instanceId));
        }
        if (createLaunchConfigurationRequest.getInstanceType() != null) {
            prefix = "InstanceType";
            String instanceType = createLaunchConfigurationRequest.getInstanceType();
            request.addParameter(prefix, StringUtils.fromString((String)instanceType));
        }
        if (createLaunchConfigurationRequest.getKernelId() != null) {
            prefix = "KernelId";
            String kernelId = createLaunchConfigurationRequest.getKernelId();
            request.addParameter(prefix, StringUtils.fromString((String)kernelId));
        }
        if (createLaunchConfigurationRequest.getRamdiskId() != null) {
            prefix = "RamdiskId";
            String ramdiskId = createLaunchConfigurationRequest.getRamdiskId();
            request.addParameter(prefix, StringUtils.fromString((String)ramdiskId));
        }
        if (createLaunchConfigurationRequest.getBlockDeviceMappings() != null) {
            prefix = "BlockDeviceMappings";
            List<BlockDeviceMapping> blockDeviceMappings = createLaunchConfigurationRequest.getBlockDeviceMappings();
            int blockDeviceMappingsIndex = 1;
            String blockDeviceMappingsPrefix = prefix;
            for (BlockDeviceMapping blockDeviceMappingsItem : blockDeviceMappings) {
                prefix = blockDeviceMappingsPrefix + ".member." + blockDeviceMappingsIndex;
                if (blockDeviceMappingsItem != null) {
                    BlockDeviceMappingStaxMarshaller.getInstance().marshall(blockDeviceMappingsItem, (Request<?>)request, prefix + ".");
                }
                ++blockDeviceMappingsIndex;
            }
            prefix = blockDeviceMappingsPrefix;
        }
        if (createLaunchConfigurationRequest.getInstanceMonitoring() != null) {
            prefix = "InstanceMonitoring";
            InstanceMonitoring instanceMonitoring = createLaunchConfigurationRequest.getInstanceMonitoring();
            InstanceMonitoringStaxMarshaller.getInstance().marshall(instanceMonitoring, (Request<?>)request, prefix + ".");
        }
        if (createLaunchConfigurationRequest.getSpotPrice() != null) {
            prefix = "SpotPrice";
            String spotPrice = createLaunchConfigurationRequest.getSpotPrice();
            request.addParameter(prefix, StringUtils.fromString((String)spotPrice));
        }
        if (createLaunchConfigurationRequest.getIamInstanceProfile() != null) {
            prefix = "IamInstanceProfile";
            String iamInstanceProfile = createLaunchConfigurationRequest.getIamInstanceProfile();
            request.addParameter(prefix, StringUtils.fromString((String)iamInstanceProfile));
        }
        if (createLaunchConfigurationRequest.getEbsOptimized() != null) {
            prefix = "EbsOptimized";
            Boolean ebsOptimized = createLaunchConfigurationRequest.getEbsOptimized();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)ebsOptimized));
        }
        if (createLaunchConfigurationRequest.getAssociatePublicIpAddress() != null) {
            prefix = "AssociatePublicIpAddress";
            Boolean associatePublicIpAddress = createLaunchConfigurationRequest.getAssociatePublicIpAddress();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)associatePublicIpAddress));
        }
        if (createLaunchConfigurationRequest.getPlacementTenancy() != null) {
            prefix = "PlacementTenancy";
            String placementTenancy = createLaunchConfigurationRequest.getPlacementTenancy();
            request.addParameter(prefix, StringUtils.fromString((String)placementTenancy));
        }
        return request;
    }
}

