/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.services.autoscaling.model.transform.TagStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import java.util.List;

public class CreateOrUpdateTagsRequestMarshaller
implements Marshaller<Request<CreateOrUpdateTagsRequest>, CreateOrUpdateTagsRequest> {
    public Request<CreateOrUpdateTagsRequest> marshall(CreateOrUpdateTagsRequest createOrUpdateTagsRequest) {
        if (createOrUpdateTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateOrUpdateTagsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createOrUpdateTagsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "CreateOrUpdateTags");
        request.addParameter("Version", "2011-01-01");
        if (createOrUpdateTagsRequest.getTags() != null) {
            String prefix = "Tags";
            List<Tag> tags = createOrUpdateTagsRequest.getTags();
            int tagsIndex = 1;
            String tagsPrefix = prefix;
            for (Tag tagsItem : tags) {
                prefix = tagsPrefix + ".member." + tagsIndex;
                if (tagsItem != null) {
                    TagStaxMarshaller.getInstance().marshall(tagsItem, (Request<?>)request, prefix + ".");
                }
                ++tagsIndex;
            }
            String string = tagsPrefix;
        }
        return request;
    }
}

