/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteAutoScalingGroupRequestMarshaller
implements Marshaller<Request<DeleteAutoScalingGroupRequest>, DeleteAutoScalingGroupRequest> {
    public Request<DeleteAutoScalingGroupRequest> marshall(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) {
        String prefix;
        if (deleteAutoScalingGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteAutoScalingGroupRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteAutoScalingGroupRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DeleteAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        if (deleteAutoScalingGroupRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = deleteAutoScalingGroupRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (deleteAutoScalingGroupRequest.getForceDelete() != null) {
            prefix = "ForceDelete";
            Boolean forceDelete = deleteAutoScalingGroupRequest.getForceDelete();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)forceDelete));
        }
        return request;
    }
}

