/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteNotificationConfigurationRequestMarshaller
implements Marshaller<Request<DeleteNotificationConfigurationRequest>, DeleteNotificationConfigurationRequest> {
    public Request<DeleteNotificationConfigurationRequest> marshall(DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) {
        String prefix;
        if (deleteNotificationConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteNotificationConfigurationRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteNotificationConfigurationRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DeleteNotificationConfiguration");
        request.addParameter("Version", "2011-01-01");
        if (deleteNotificationConfigurationRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = deleteNotificationConfigurationRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (deleteNotificationConfigurationRequest.getTopicARN() != null) {
            prefix = "TopicARN";
            String topicARN = deleteNotificationConfigurationRequest.getTopicARN();
            request.addParameter(prefix, StringUtils.fromString((String)topicARN));
        }
        return request;
    }
}

