/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteScheduledActionRequestMarshaller
implements Marshaller<Request<DeleteScheduledActionRequest>, DeleteScheduledActionRequest> {
    public Request<DeleteScheduledActionRequest> marshall(DeleteScheduledActionRequest deleteScheduledActionRequest) {
        String prefix;
        if (deleteScheduledActionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteScheduledActionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteScheduledActionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DeleteScheduledAction");
        request.addParameter("Version", "2011-01-01");
        if (deleteScheduledActionRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = deleteScheduledActionRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (deleteScheduledActionRequest.getScheduledActionName() != null) {
            prefix = "ScheduledActionName";
            String scheduledActionName = deleteScheduledActionRequest.getScheduledActionName();
            request.addParameter(prefix, StringUtils.fromString((String)scheduledActionName));
        }
        return request;
    }
}

