/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DeleteTagsRequest;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.services.autoscaling.model.transform.TagStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import java.util.List;

public class DeleteTagsRequestMarshaller
implements Marshaller<Request<DeleteTagsRequest>, DeleteTagsRequest> {
    public Request<DeleteTagsRequest> marshall(DeleteTagsRequest deleteTagsRequest) {
        if (deleteTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteTagsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteTagsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DeleteTags");
        request.addParameter("Version", "2011-01-01");
        if (deleteTagsRequest.getTags() != null) {
            String prefix = "Tags";
            List<Tag> tags = deleteTagsRequest.getTags();
            int tagsIndex = 1;
            String tagsPrefix = prefix;
            for (Tag tagsItem : tags) {
                prefix = tagsPrefix + ".member." + tagsIndex;
                if (tagsItem != null) {
                    TagStaxMarshaller.getInstance().marshall(tagsItem, (Request<?>)request, prefix + ".");
                }
                ++tagsIndex;
            }
            String string = tagsPrefix;
        }
        return request;
    }
}

