/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeAutoScalingGroupsRequestMarshaller
implements Marshaller<Request<DescribeAutoScalingGroupsRequest>, DescribeAutoScalingGroupsRequest> {
    public Request<DescribeAutoScalingGroupsRequest> marshall(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        String prefix;
        if (describeAutoScalingGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeAutoScalingGroupsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAutoScalingGroupsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeAutoScalingGroups");
        request.addParameter("Version", "2011-01-01");
        if (describeAutoScalingGroupsRequest.getAutoScalingGroupNames() != null) {
            prefix = "AutoScalingGroupNames";
            List<String> autoScalingGroupNames = describeAutoScalingGroupsRequest.getAutoScalingGroupNames();
            int autoScalingGroupNamesIndex = 1;
            String autoScalingGroupNamesPrefix = prefix;
            for (String autoScalingGroupNamesItem : autoScalingGroupNames) {
                prefix = autoScalingGroupNamesPrefix + ".member." + autoScalingGroupNamesIndex;
                if (autoScalingGroupNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupNamesItem));
                }
                ++autoScalingGroupNamesIndex;
            }
            prefix = autoScalingGroupNamesPrefix;
        }
        if (describeAutoScalingGroupsRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = describeAutoScalingGroupsRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        if (describeAutoScalingGroupsRequest.getMaxRecords() != null) {
            prefix = "MaxRecords";
            Integer maxRecords = describeAutoScalingGroupsRequest.getMaxRecords();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxRecords));
        }
        return request;
    }
}

