/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeScalingActivitiesRequestMarshaller
implements Marshaller<Request<DescribeScalingActivitiesRequest>, DescribeScalingActivitiesRequest> {
    public Request<DescribeScalingActivitiesRequest> marshall(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        String prefix;
        if (describeScalingActivitiesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DescribeScalingActivitiesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeScalingActivitiesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeScalingActivities");
        request.addParameter("Version", "2011-01-01");
        if (describeScalingActivitiesRequest.getActivityIds() != null) {
            prefix = "ActivityIds";
            List<String> activityIds = describeScalingActivitiesRequest.getActivityIds();
            int activityIdsIndex = 1;
            String activityIdsPrefix = prefix;
            for (String activityIdsItem : activityIds) {
                prefix = activityIdsPrefix + ".member." + activityIdsIndex;
                if (activityIdsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)activityIdsItem));
                }
                ++activityIdsIndex;
            }
            prefix = activityIdsPrefix;
        }
        if (describeScalingActivitiesRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = describeScalingActivitiesRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (describeScalingActivitiesRequest.getMaxRecords() != null) {
            prefix = "MaxRecords";
            Integer maxRecords = describeScalingActivitiesRequest.getMaxRecords();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxRecords));
        }
        if (describeScalingActivitiesRequest.getNextToken() != null) {
            prefix = "NextToken";
            String nextToken = describeScalingActivitiesRequest.getNextToken();
            request.addParameter(prefix, StringUtils.fromString((String)nextToken));
        }
        return request;
    }
}

