/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DisableMetricsCollectionRequestMarshaller
implements Marshaller<Request<DisableMetricsCollectionRequest>, DisableMetricsCollectionRequest> {
    public Request<DisableMetricsCollectionRequest> marshall(DisableMetricsCollectionRequest disableMetricsCollectionRequest) {
        String prefix;
        if (disableMetricsCollectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DisableMetricsCollectionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)disableMetricsCollectionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DisableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        if (disableMetricsCollectionRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = disableMetricsCollectionRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (disableMetricsCollectionRequest.getMetrics() != null) {
            prefix = "Metrics";
            List<String> metrics = disableMetricsCollectionRequest.getMetrics();
            int metricsIndex = 1;
            String metricsPrefix = prefix;
            for (String metricsItem : metrics) {
                prefix = metricsPrefix + ".member." + metricsIndex;
                if (metricsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)metricsItem));
                }
                ++metricsIndex;
            }
            String string = metricsPrefix;
        }
        return request;
    }
}

