/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.EnterStandbyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class EnterStandbyRequestMarshaller
implements Marshaller<Request<EnterStandbyRequest>, EnterStandbyRequest> {
    public Request<EnterStandbyRequest> marshall(EnterStandbyRequest enterStandbyRequest) {
        String prefix;
        if (enterStandbyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(EnterStandbyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enterStandbyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "EnterStandby");
        request.addParameter("Version", "2011-01-01");
        if (enterStandbyRequest.getInstanceIds() != null) {
            prefix = "InstanceIds";
            List<String> instanceIds = enterStandbyRequest.getInstanceIds();
            int instanceIdsIndex = 1;
            String instanceIdsPrefix = prefix;
            for (String instanceIdsItem : instanceIds) {
                prefix = instanceIdsPrefix + ".member." + instanceIdsIndex;
                if (instanceIdsItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)instanceIdsItem));
                }
                ++instanceIdsIndex;
            }
            prefix = instanceIdsPrefix;
        }
        if (enterStandbyRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = enterStandbyRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (enterStandbyRequest.getShouldDecrementDesiredCapacity() != null) {
            prefix = "ShouldDecrementDesiredCapacity";
            Boolean shouldDecrementDesiredCapacity = enterStandbyRequest.getShouldDecrementDesiredCapacity();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)shouldDecrementDesiredCapacity));
        }
        return request;
    }
}

