/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class PutNotificationConfigurationRequestMarshaller
implements Marshaller<Request<PutNotificationConfigurationRequest>, PutNotificationConfigurationRequest> {
    public Request<PutNotificationConfigurationRequest> marshall(PutNotificationConfigurationRequest putNotificationConfigurationRequest) {
        String prefix;
        if (putNotificationConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PutNotificationConfigurationRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putNotificationConfigurationRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutNotificationConfiguration");
        request.addParameter("Version", "2011-01-01");
        if (putNotificationConfigurationRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = putNotificationConfigurationRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (putNotificationConfigurationRequest.getTopicARN() != null) {
            prefix = "TopicARN";
            String topicARN = putNotificationConfigurationRequest.getTopicARN();
            request.addParameter(prefix, StringUtils.fromString((String)topicARN));
        }
        if (putNotificationConfigurationRequest.getNotificationTypes() != null) {
            prefix = "NotificationTypes";
            List<String> notificationTypes = putNotificationConfigurationRequest.getNotificationTypes();
            int notificationTypesIndex = 1;
            String notificationTypesPrefix = prefix;
            for (String notificationTypesItem : notificationTypes) {
                prefix = notificationTypesPrefix + ".member." + notificationTypesIndex;
                if (notificationTypesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)notificationTypesItem));
                }
                ++notificationTypesIndex;
            }
            String string = notificationTypesPrefix;
        }
        return request;
    }
}

