/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class PutScheduledUpdateGroupActionRequestMarshaller
implements Marshaller<Request<PutScheduledUpdateGroupActionRequest>, PutScheduledUpdateGroupActionRequest> {
    public Request<PutScheduledUpdateGroupActionRequest> marshall(PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) {
        String prefix;
        if (putScheduledUpdateGroupActionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PutScheduledUpdateGroupActionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putScheduledUpdateGroupActionRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutScheduledUpdateGroupAction");
        request.addParameter("Version", "2011-01-01");
        if (putScheduledUpdateGroupActionRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = putScheduledUpdateGroupActionRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (putScheduledUpdateGroupActionRequest.getScheduledActionName() != null) {
            prefix = "ScheduledActionName";
            String scheduledActionName = putScheduledUpdateGroupActionRequest.getScheduledActionName();
            request.addParameter(prefix, StringUtils.fromString((String)scheduledActionName));
        }
        if (putScheduledUpdateGroupActionRequest.getTime() != null) {
            prefix = "Time";
            Date time = putScheduledUpdateGroupActionRequest.getTime();
            request.addParameter(prefix, StringUtils.fromDate((Date)time));
        }
        if (putScheduledUpdateGroupActionRequest.getStartTime() != null) {
            prefix = "StartTime";
            Date startTime = putScheduledUpdateGroupActionRequest.getStartTime();
            request.addParameter(prefix, StringUtils.fromDate((Date)startTime));
        }
        if (putScheduledUpdateGroupActionRequest.getEndTime() != null) {
            prefix = "EndTime";
            Date endTime = putScheduledUpdateGroupActionRequest.getEndTime();
            request.addParameter(prefix, StringUtils.fromDate((Date)endTime));
        }
        if (putScheduledUpdateGroupActionRequest.getRecurrence() != null) {
            prefix = "Recurrence";
            String recurrence = putScheduledUpdateGroupActionRequest.getRecurrence();
            request.addParameter(prefix, StringUtils.fromString((String)recurrence));
        }
        if (putScheduledUpdateGroupActionRequest.getMinSize() != null) {
            prefix = "MinSize";
            Integer minSize = putScheduledUpdateGroupActionRequest.getMinSize();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)minSize));
        }
        if (putScheduledUpdateGroupActionRequest.getMaxSize() != null) {
            prefix = "MaxSize";
            Integer maxSize = putScheduledUpdateGroupActionRequest.getMaxSize();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxSize));
        }
        if (putScheduledUpdateGroupActionRequest.getDesiredCapacity() != null) {
            prefix = "DesiredCapacity";
            Integer desiredCapacity = putScheduledUpdateGroupActionRequest.getDesiredCapacity();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)desiredCapacity));
        }
        return request;
    }
}

