/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.Alarm;
import com.amazonaws.services.autoscaling.model.ScalingPolicy;
import com.amazonaws.services.autoscaling.model.StepAdjustment;
import com.amazonaws.services.autoscaling.model.TargetTrackingConfiguration;
import com.amazonaws.services.autoscaling.model.transform.AlarmStaxMarshaller;
import com.amazonaws.services.autoscaling.model.transform.StepAdjustmentStaxMarshaller;
import com.amazonaws.services.autoscaling.model.transform.TargetTrackingConfigurationStaxMarshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

class ScalingPolicyStaxMarshaller {
    private static ScalingPolicyStaxMarshaller instance;

    ScalingPolicyStaxMarshaller() {
    }

    public void marshall(ScalingPolicy _scalingPolicy, Request<?> request, String _prefix) {
        String prefix;
        if (_scalingPolicy.getAutoScalingGroupName() != null) {
            prefix = _prefix + "AutoScalingGroupName";
            String autoScalingGroupName = _scalingPolicy.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (_scalingPolicy.getPolicyName() != null) {
            prefix = _prefix + "PolicyName";
            String policyName = _scalingPolicy.getPolicyName();
            request.addParameter(prefix, StringUtils.fromString((String)policyName));
        }
        if (_scalingPolicy.getPolicyARN() != null) {
            prefix = _prefix + "PolicyARN";
            String policyARN = _scalingPolicy.getPolicyARN();
            request.addParameter(prefix, StringUtils.fromString((String)policyARN));
        }
        if (_scalingPolicy.getPolicyType() != null) {
            prefix = _prefix + "PolicyType";
            String policyType = _scalingPolicy.getPolicyType();
            request.addParameter(prefix, StringUtils.fromString((String)policyType));
        }
        if (_scalingPolicy.getAdjustmentType() != null) {
            prefix = _prefix + "AdjustmentType";
            String adjustmentType = _scalingPolicy.getAdjustmentType();
            request.addParameter(prefix, StringUtils.fromString((String)adjustmentType));
        }
        if (_scalingPolicy.getMinAdjustmentStep() != null) {
            prefix = _prefix + "MinAdjustmentStep";
            Integer minAdjustmentStep = _scalingPolicy.getMinAdjustmentStep();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)minAdjustmentStep));
        }
        if (_scalingPolicy.getMinAdjustmentMagnitude() != null) {
            prefix = _prefix + "MinAdjustmentMagnitude";
            Integer minAdjustmentMagnitude = _scalingPolicy.getMinAdjustmentMagnitude();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)minAdjustmentMagnitude));
        }
        if (_scalingPolicy.getScalingAdjustment() != null) {
            prefix = _prefix + "ScalingAdjustment";
            Integer scalingAdjustment = _scalingPolicy.getScalingAdjustment();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)scalingAdjustment));
        }
        if (_scalingPolicy.getCooldown() != null) {
            prefix = _prefix + "Cooldown";
            Integer cooldown = _scalingPolicy.getCooldown();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)cooldown));
        }
        if (_scalingPolicy.getStepAdjustments() != null) {
            prefix = _prefix + "StepAdjustments";
            List<StepAdjustment> stepAdjustments = _scalingPolicy.getStepAdjustments();
            int stepAdjustmentsIndex = 1;
            String stepAdjustmentsPrefix = prefix;
            for (StepAdjustment stepAdjustmentsItem : stepAdjustments) {
                prefix = stepAdjustmentsPrefix + ".member." + stepAdjustmentsIndex;
                if (stepAdjustmentsItem != null) {
                    StepAdjustmentStaxMarshaller.getInstance().marshall(stepAdjustmentsItem, request, prefix + ".");
                }
                ++stepAdjustmentsIndex;
            }
            prefix = stepAdjustmentsPrefix;
        }
        if (_scalingPolicy.getMetricAggregationType() != null) {
            prefix = _prefix + "MetricAggregationType";
            String metricAggregationType = _scalingPolicy.getMetricAggregationType();
            request.addParameter(prefix, StringUtils.fromString((String)metricAggregationType));
        }
        if (_scalingPolicy.getEstimatedInstanceWarmup() != null) {
            prefix = _prefix + "EstimatedInstanceWarmup";
            Integer estimatedInstanceWarmup = _scalingPolicy.getEstimatedInstanceWarmup();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)estimatedInstanceWarmup));
        }
        if (_scalingPolicy.getAlarms() != null) {
            prefix = _prefix + "Alarms";
            List<Alarm> alarms = _scalingPolicy.getAlarms();
            int alarmsIndex = 1;
            String alarmsPrefix = prefix;
            for (Alarm alarmsItem : alarms) {
                prefix = alarmsPrefix + ".member." + alarmsIndex;
                if (alarmsItem != null) {
                    AlarmStaxMarshaller.getInstance().marshall(alarmsItem, request, prefix + ".");
                }
                ++alarmsIndex;
            }
            prefix = alarmsPrefix;
        }
        if (_scalingPolicy.getTargetTrackingConfiguration() != null) {
            prefix = _prefix + "TargetTrackingConfiguration";
            TargetTrackingConfiguration targetTrackingConfiguration = _scalingPolicy.getTargetTrackingConfiguration();
            TargetTrackingConfigurationStaxMarshaller.getInstance().marshall(targetTrackingConfiguration, request, prefix + ".");
        }
    }

    public static ScalingPolicyStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new ScalingPolicyStaxMarshaller();
        }
        return instance;
    }
}

