/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SetDesiredCapacityRequestMarshaller
implements Marshaller<Request<SetDesiredCapacityRequest>, SetDesiredCapacityRequest> {
    public Request<SetDesiredCapacityRequest> marshall(SetDesiredCapacityRequest setDesiredCapacityRequest) {
        String prefix;
        if (setDesiredCapacityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetDesiredCapacityRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setDesiredCapacityRequest, "AmazonAutoScaling");
        request.addParameter("Action", "SetDesiredCapacity");
        request.addParameter("Version", "2011-01-01");
        if (setDesiredCapacityRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = setDesiredCapacityRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (setDesiredCapacityRequest.getDesiredCapacity() != null) {
            prefix = "DesiredCapacity";
            Integer desiredCapacity = setDesiredCapacityRequest.getDesiredCapacity();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)desiredCapacity));
        }
        if (setDesiredCapacityRequest.getHonorCooldown() != null) {
            prefix = "HonorCooldown";
            Boolean honorCooldown = setDesiredCapacityRequest.getHonorCooldown();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)honorCooldown));
        }
        return request;
    }
}

