/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SetInstanceHealthRequestMarshaller
implements Marshaller<Request<SetInstanceHealthRequest>, SetInstanceHealthRequest> {
    public Request<SetInstanceHealthRequest> marshall(SetInstanceHealthRequest setInstanceHealthRequest) {
        String prefix;
        if (setInstanceHealthRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetInstanceHealthRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setInstanceHealthRequest, "AmazonAutoScaling");
        request.addParameter("Action", "SetInstanceHealth");
        request.addParameter("Version", "2011-01-01");
        if (setInstanceHealthRequest.getInstanceId() != null) {
            prefix = "InstanceId";
            String instanceId = setInstanceHealthRequest.getInstanceId();
            request.addParameter(prefix, StringUtils.fromString((String)instanceId));
        }
        if (setInstanceHealthRequest.getHealthStatus() != null) {
            prefix = "HealthStatus";
            String healthStatus = setInstanceHealthRequest.getHealthStatus();
            request.addParameter(prefix, StringUtils.fromString((String)healthStatus));
        }
        if (setInstanceHealthRequest.getShouldRespectGracePeriod() != null) {
            prefix = "ShouldRespectGracePeriod";
            Boolean shouldRespectGracePeriod = setInstanceHealthRequest.getShouldRespectGracePeriod();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)shouldRespectGracePeriod));
        }
        return request;
    }
}

