/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.transform.LaunchTemplateSpecificationStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class UpdateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<UpdateAutoScalingGroupRequest>, UpdateAutoScalingGroupRequest> {
    public Request<UpdateAutoScalingGroupRequest> marshall(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) {
        String prefix;
        if (updateAutoScalingGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateAutoScalingGroupRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateAutoScalingGroupRequest, "AmazonAutoScaling");
        request.addParameter("Action", "UpdateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        if (updateAutoScalingGroupRequest.getAutoScalingGroupName() != null) {
            prefix = "AutoScalingGroupName";
            String autoScalingGroupName = updateAutoScalingGroupRequest.getAutoScalingGroupName();
            request.addParameter(prefix, StringUtils.fromString((String)autoScalingGroupName));
        }
        if (updateAutoScalingGroupRequest.getLaunchConfigurationName() != null) {
            prefix = "LaunchConfigurationName";
            String launchConfigurationName = updateAutoScalingGroupRequest.getLaunchConfigurationName();
            request.addParameter(prefix, StringUtils.fromString((String)launchConfigurationName));
        }
        if (updateAutoScalingGroupRequest.getLaunchTemplate() != null) {
            prefix = "LaunchTemplate";
            LaunchTemplateSpecification launchTemplate = updateAutoScalingGroupRequest.getLaunchTemplate();
            LaunchTemplateSpecificationStaxMarshaller.getInstance().marshall(launchTemplate, (Request<?>)request, prefix + ".");
        }
        if (updateAutoScalingGroupRequest.getMinSize() != null) {
            prefix = "MinSize";
            Integer minSize = updateAutoScalingGroupRequest.getMinSize();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)minSize));
        }
        if (updateAutoScalingGroupRequest.getMaxSize() != null) {
            prefix = "MaxSize";
            Integer maxSize = updateAutoScalingGroupRequest.getMaxSize();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxSize));
        }
        if (updateAutoScalingGroupRequest.getDesiredCapacity() != null) {
            prefix = "DesiredCapacity";
            Integer desiredCapacity = updateAutoScalingGroupRequest.getDesiredCapacity();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)desiredCapacity));
        }
        if (updateAutoScalingGroupRequest.getDefaultCooldown() != null) {
            prefix = "DefaultCooldown";
            Integer defaultCooldown = updateAutoScalingGroupRequest.getDefaultCooldown();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)defaultCooldown));
        }
        if (updateAutoScalingGroupRequest.getAvailabilityZones() != null) {
            prefix = "AvailabilityZones";
            List<String> availabilityZones = updateAutoScalingGroupRequest.getAvailabilityZones();
            int availabilityZonesIndex = 1;
            String availabilityZonesPrefix = prefix;
            for (String availabilityZonesItem : availabilityZones) {
                prefix = availabilityZonesPrefix + ".member." + availabilityZonesIndex;
                if (availabilityZonesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)availabilityZonesItem));
                }
                ++availabilityZonesIndex;
            }
            prefix = availabilityZonesPrefix;
        }
        if (updateAutoScalingGroupRequest.getHealthCheckType() != null) {
            prefix = "HealthCheckType";
            String healthCheckType = updateAutoScalingGroupRequest.getHealthCheckType();
            request.addParameter(prefix, StringUtils.fromString((String)healthCheckType));
        }
        if (updateAutoScalingGroupRequest.getHealthCheckGracePeriod() != null) {
            prefix = "HealthCheckGracePeriod";
            Integer healthCheckGracePeriod = updateAutoScalingGroupRequest.getHealthCheckGracePeriod();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)healthCheckGracePeriod));
        }
        if (updateAutoScalingGroupRequest.getPlacementGroup() != null) {
            prefix = "PlacementGroup";
            String placementGroup = updateAutoScalingGroupRequest.getPlacementGroup();
            request.addParameter(prefix, StringUtils.fromString((String)placementGroup));
        }
        if (updateAutoScalingGroupRequest.getVPCZoneIdentifier() != null) {
            prefix = "VPCZoneIdentifier";
            String vPCZoneIdentifier = updateAutoScalingGroupRequest.getVPCZoneIdentifier();
            request.addParameter(prefix, StringUtils.fromString((String)vPCZoneIdentifier));
        }
        if (updateAutoScalingGroupRequest.getTerminationPolicies() != null) {
            prefix = "TerminationPolicies";
            List<String> terminationPolicies = updateAutoScalingGroupRequest.getTerminationPolicies();
            int terminationPoliciesIndex = 1;
            String terminationPoliciesPrefix = prefix;
            for (String terminationPoliciesItem : terminationPolicies) {
                prefix = terminationPoliciesPrefix + ".member." + terminationPoliciesIndex;
                if (terminationPoliciesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)terminationPoliciesItem));
                }
                ++terminationPoliciesIndex;
            }
            prefix = terminationPoliciesPrefix;
        }
        if (updateAutoScalingGroupRequest.getNewInstancesProtectedFromScaleIn() != null) {
            prefix = "NewInstancesProtectedFromScaleIn";
            Boolean newInstancesProtectedFromScaleIn = updateAutoScalingGroupRequest.getNewInstancesProtectedFromScaleIn();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)newInstancesProtectedFromScaleIn));
        }
        if (updateAutoScalingGroupRequest.getServiceLinkedRoleARN() != null) {
            prefix = "ServiceLinkedRoleARN";
            String serviceLinkedRoleARN = updateAutoScalingGroupRequest.getServiceLinkedRoleARN();
            request.addParameter(prefix, StringUtils.fromString((String)serviceLinkedRoleARN));
        }
        return request;
    }
}

