/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.services.cloudwatch.model.Metric;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListMetricsResult
implements Serializable {
    private List<Metric> metrics = new ArrayList<Metric>();
    private String nextToken;

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Collection<Metric> metrics) {
        if (metrics == null) {
            this.metrics = null;
            return;
        }
        this.metrics = new ArrayList<Metric>(metrics);
    }

    public ListMetricsResult withMetrics(Metric ... metrics) {
        if (this.getMetrics() == null) {
            this.metrics = new ArrayList<Metric>(metrics.length);
        }
        for (Metric value : metrics) {
            this.metrics.add(value);
        }
        return this;
    }

    public ListMetricsResult withMetrics(Collection<Metric> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListMetricsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetrics() != null) {
            sb.append("Metrics: " + this.getMetrics() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsResult)) {
            return false;
        }
        ListMetricsResult other = (ListMetricsResult)obj;
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

